/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.adapterservices;

import java.io.IOException;
import java.util.Date;
import javax.xml.ws.Endpoint;

/**
 * Der Deployer für den Adapter-Webservice
 * @author Marc Beck
 */
public class WSDeployer extends Thread {

    private static final String ENDPOINT_ADDRESS = "http://localhost:8088/AdapterWS";
    private static Endpoint endpoint;
    private static Thread thread;

    @Override
    public void run() {

        AdapterWebService adapterWS = new AdapterWebService();
        endpoint = Endpoint.publish(ENDPOINT_ADDRESS, adapterWS);

        thread = this;
        try {
            while (thread != null) {
                System.in.read();
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public synchronized String startServer() {
        if (thread == null) {
            start();
            return "Server startup at " + new Date() + "\nServer Endpoint: " + ENDPOINT_ADDRESS;
        } else {
            return "Server is already up and running!" + "\nServer Endpoint: " + ENDPOINT_ADDRESS;
        }
    }

    public synchronized String shutdownServer() {
        if (endpoint != null) {
            endpoint.stop();
            thread = null;
            interrupt();
            return "Server shutdown at " + new Date();
        }
        return "Not running!";

    }

    public synchronized boolean alive() {
        return thread != null;
    }
}


