/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
package de.umweltcampus.uput.informatik.openeanvadapter.communication.logging;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.AddressDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.MessageDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.BasicOSCIMessage;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Message;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Marc Beck
 */
public class ZKSMessageLogger {

    private MessageDAO enjc;
    private AddressDAO uajc;

    public ZKSMessageLogger() {
        this.enjc = new MessageDAO();
        this.uajc = new AddressDAO();
    }

    /**
     * Speichert eine Nachricht in der DB
     * @param message Die Nachricht als XML String
     * @param type Typ der Nachricht
     * @param receiver Empfänger der Nachricht
     */
    public void logEmpfangeneNachricht(byte[] message, String type, Address receiver) {
        logEmpfangeneNachricht(message, type, receiver, null, null);
    }

    /**
     * Speichert eine Nachricht in der DB<br/>
     * Zudem wird die UnternehmensAdresse geupdated.
     * @param message Die Nachricht als XML String
     * @param type Typ der Nachricht
     * @param receiver Empfänger der Nachricht
     * @param subject Betreff der Nachricht, kann null sein
     * @param osciMessages OSCI Nachrichten, die mit der Nachricht in Verbindung stehen
     */
    public void logEmpfangeneNachricht(byte[] message, String type, Address receiver, String subject, List<BasicOSCIMessage> osciMessages) {
        //Empfangene Nachricht bauen
        Message empfangeneNachricht = new Message();
        empfangeneNachricht.setListedSince(new Date());
        empfangeneNachricht.setMessage(message);
        empfangeneNachricht.setType(type);
        empfangeneNachricht.setSubjectString(subject);
        empfangeneNachricht.setReceiver(receiver);
        empfangeneNachricht.setOsciMessages(osciMessages);
        //persistieren
        enjc.create(empfangeneNachricht);
        //Unternehmensadresse updaten
        uajc.edit(receiver);

    }

    /**
     * Speichert eine Nachricht in der DB
     * @param message Die Nachricht als XML String
     * @param type Typ der Nachricht
     * @param sender Absender der Nachricht
     * @param subject Betreff der Nachricht, kann null sein
     * @param osciMessages OSCI Nachrichten, die mit der Nachricht in Verbindung stehen
     */
    public void logGesendeteNachricht(byte[] message, String type, Address sender, String subject, List<BasicOSCIMessage> osciMessages) {
        //Gesendete Nachricht bauen
        Message gesendeteNachricht = new Message();
        gesendeteNachricht.setRetrieved(false);
        gesendeteNachricht.setListedSince(new Date());
        gesendeteNachricht.setMessage(message);
        gesendeteNachricht.setType(type);
        gesendeteNachricht.setSubjectString(subject);
        gesendeteNachricht.setSender(sender);
        gesendeteNachricht.setOsciMessages(osciMessages);
        //persistieren
        enjc.create(gesendeteNachricht);
    }

}
