/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.osci;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.Profil;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import java.util.List;

/**
 * Proxy-Klasse zum Maskieren der OSCI-Kommunikation
 * @author Marc Beck
 */
public class OSCIProxy {

    private final OSCIMessageService messageService;

    public OSCIProxy() {
        Company company = CompanyFacade.getCompany();
        ZKSConfiguration config = company.getzKSConfig();
        this.messageService = new OSCIMessageService(config.getCertificateIntermed().getCertificate(), config.getAddressIntermed());
    }

    public String send(Address sender, byte[] receiverCert, Profil profil, byte[] message) {
        //Subject (Profilierung)
        String subject = profil.getProfilString();
        //Senden:
        OSCILogData logData = new OSCILogData(sender);
        String response = messageService.send(logData, receiverCert, subject, message);
        return response;

    }

    public String receive(Address address) {
        OSCILogData logData = new OSCILogData(address);
        String response = messageService.receive(logData);
        return response;
    }

    /**
     * Holt eine Nachricht mit der übergebenen ID ab.
     * @param ua
     * @param messageId
     * @return
     */
    public byte[] receiveMessageById(Address ua, String messageId) {
        OSCILogData logData = new OSCILogData(ua);
        return messageService.receiveMessageById(logData, messageId);
    }

    /**
     * Liefert eine Liste mit MessageHeaderContainern aller Nachrichten im Postfach des Empfängers
     * @param ua
     * @return
     */
    public List<MessageHeaderContainer> getMessageList(Address ua) {
        return messageService.getMessageList(ua.getPrivateCertificate().getCertificate(), ua.getPrivateCertificate().getPassword());
    }
}
