/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.osci;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageSigner;
import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageType;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.ZKSMessageGenerator;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.ZKSMessageGeneratorFactory;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.ZKSParameterAnfrageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.DocumentType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.Profil;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;

/**
 *
 * @author Timo
 */
public class ParameterService {

    public void sendZKSParametersRequest() {

        Company company = CompanyFacade.getCompany();
        Address defaultAddress = company.getDefaultAddress();
        ZKSConfiguration configuration = company.getzKSConfig();


        ZKSParameterAnfrageDataContainer container = new ZKSParameterAnfrageDataContainer(defaultAddress.getRegisterNumber(), defaultAddress.getRoleType().toString());

        container.setAtbRolle(defaultAddress.getRoleType().toString());
        container.setBehoerdlicheNummer(defaultAddress.getRegisterNumber().toString());

        ProfilBuilder builder = new ProfilBuilder();
        Profil profil = builder.buildProfil(configuration, defaultAddress, DocumentType.ZKSParameterAnfrage, "1e239412-d007-7");
        ZKSMessageGenerator generator = new ZKSMessageGeneratorFactory().getGenerator(container);
        byte[] message = generator.generateMessage(container);
        ZKSMessageSigner messageSigner = new ZKSMessageSigner();
        ZKSMessageSigner.SignatureMetaData metaData = messageSigner.buildMetaData(defaultAddress.getPrivateCertificate().getCertificate(), defaultAddress.getPrivateCertificate().getPassword(), defaultAddress.getRoleType().toString());
        System.out.println(new OSCIProxy().send(defaultAddress, configuration.getCertificateServicemodul().getCertificate(), profil, new ZKSMessageSigner().signMessage(message, metaData, ZKSMessageType.ZKSPARAMETERANFRAGE)));
    }
}
