/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.osci;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.CommonException;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.DocumentType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.Profil;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Marc Beck
 */
public class ProfilBuilder {

    public Profil buildProfil(Address empfaenger, Address absender, DocumentType messageType, String msgId) {
        try {
            String empfaengerNr = empfaenger.getRegisterNumber() + ZKSMessageUtil.getPruefziffer(empfaenger.getRegisterNumber());
            RoleType empfaengerRolle = empfaenger.getRoleType();
            String absenderNr = absender.getRegisterNumber() + ZKSMessageUtil.getPruefziffer(absender.getRegisterNumber());
            RoleType absenderRolle = absender.getRoleType();
            Profil profil = new Profil(empfaengerNr, empfaengerRolle, absenderNr, absenderRolle, messageType, msgId);

            return profil;
        } catch (CommonException ex) {
            Logger.getLogger(ProfilBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }
    public Profil buildProfil(ZKSConfiguration configuration, Address absender, DocumentType messageType, String msgId) {
        try {
            String empfaengerNr = configuration.getRegisterNumber() + ZKSMessageUtil.getPruefziffer(configuration.getRegisterNumber());
            RoleType empfaengerRolle = configuration.getRoleTypeZKS();
            String absenderNr = absender.getRegisterNumber() + ZKSMessageUtil.getPruefziffer(absender.getRegisterNumber());
            RoleType absenderRolle = absender.getRoleType();
            Profil profil = new Profil(empfaengerNr, empfaengerRolle, absenderNr, absenderRolle, messageType, msgId);

            return profil;
        } catch (CommonException ex) {
            Logger.getLogger(ProfilBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

}
