/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.logging.ZKSMessageLogger;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.ZKSMessageGenerator;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.ZKSMessageGeneratorFactory;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AbstractZKSMessageProcessor;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.ZKSMessageProcessorFactory;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Zentrale Schnittstelle für ZKS-Adressnachrichten
 * @author Marc Beck
 */
public class MessageService {

    private final ZKSMessageLogger logger;

    /**
     * Konstruktor
     */
    public MessageService() {
        this.logger = new ZKSMessageLogger();
    }

    /**
     * Sendet eine Adressnachricht mit dem Typ messageType
     * und den Daten im MessageDataContainer dataContainer
     * an die ZKS. Verwendet dabei die Default-Adresse
     * <br>
     * @param dataContainer
     * @param messageType
     * @return einen Processor, der die Nachricht verarbeiten kann.
     */
    public AbstractZKSMessageProcessor sendMessageViaWS(MessageDataContainer dataContainer, ZKSMessageType messageType) {
        //Als Absenderadresse die Default-Adresse auswählen
        Address sender = this.getDefaultAddress();
        //Nachricht generieren
        ZKSMessageGeneratorFactory factory = new ZKSMessageGeneratorFactory();
        ZKSMessageGenerator generator = factory.getGenerator(dataContainer);
        //Generator verwenden um Nachricht zu erzeugen
        byte[] message = generator.generateMessage(dataContainer);
        //Signieren
        ZKSMessageSigner messageSigner = new ZKSMessageSigner();
        ZKSMessageSigner.SignatureMetaData metaData = messageSigner.buildMetaData(sender.getPrivateCertificate().getCertificate(), sender.getPrivateCertificate().getPassword(), sender.getRoleType().toString());
        message = messageSigner.signMessage(message, metaData, messageType);
        //System.out.println("Nachricht wird über Webservice versendet");
        //Nachricht sichern
        logger.logGesendeteNachricht(message, messageType.toString(), sender, null, null);
        //Den String an den Webservice schicken
        ZKSWebservice zKSWebservice = new ZKSWebservice();
        String response = zKSWebservice.sendAdressnachricht(new String(message));
        //System.out.println("Antwort erhalten...");
        //Antwort erkennen und loggen
        String responseMessageType = ZKSMessageUtil.detectMessageType(response);
        try {
            logger.logEmpfangeneNachricht(response.getBytes("UTF-8"), responseMessageType, sender);
        } catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MessageService.class.getName()).log(Level.SEVERE, null, ex);
        }
        //Processor finden
        ZKSMessageProcessorFactory processorFactory = new ZKSMessageProcessorFactory();
        AbstractZKSMessageProcessor processor = processorFactory.getProcessor(responseMessageType);
        processor.processMessage(response);
        //Processor zurück liefern
        return processor;
    }

    public Address getDefaultAddress() {
        Company company = CompanyFacade.getCompany();
        Address defaultAddress = company.getDefaultAddress();
        return defaultAddress;
    }
}
