/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
package de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices;

/**
 * Enumeration der ZKS-Nachrichtentypen
 * <br>Verwendet die tatsächlichen Tag-Namen!<br>
 * @author Marc Beck
 */
public enum ZKSMessageType {

    ADRESSANFORDERUNG {

        @Override
        public String toString() {
            return "Adressanforderung";
        }
    },
    ADRESSANFRAGE {

        @Override
        public String toString() {
            return "Adressanfrage";
        }
    },
    ADRESSANTWORT {

        @Override
        public String toString() {
            return "Adressantwort";
        }
    },
    ADRESSAUSKUNFT {

        @Override
        public String toString() {
            return "Adressauskunft";
        }
    },
    ATBLISTENWL {

        @Override
        public String toString() {
            return "ATBListeNWL";
        }
    },
    NACHWEISLISTE {

        @Override
        public String toString() {
            return "Nachweisliste";
        }
    },
    REGISTRIERUNGSQUITTUNG {

        @Override
        public String toString() {
            return "Registrierungsquittung";
        }
    },
    ZERTIFIKATSUEBERMITTLUNG {

        @Override
        public String toString() {
            return "Zertifikatsuebermittlung";
        }
    },
    ZKSAUFTRAG {

        @Override
        public String toString() {
            return "ZKSAuftrag";
        }
    },
    ZKSERGEBNIS {

        @Override
        public String toString() {
            return "ZKSErgebnis";
        }
    },
    ZKSPARAMETERANFRAGE {

        @Override
        public String toString() {
            return "ZKSParameterAnfrage";
        }
    },
    ZKSPARAMETERERGEBNIS {

        @Override
        public String toString() {
            return "ZKSParameterErgebnis";
        }
    };
}
