/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices;

import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/**
 * Hilfsmethoden für die ZKS Klassen
 * @author Marc
 */
public class ZKSMessageUtil {

    /**
     * Erkennt via XPath den Typ einer Nachricht
     * @param message
     * @return Nachrichtentyp oder "unbekannt"
     */
    public static String detectMessageType(String message) {
        String messageType = "unbekannt";
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            docBuildFactory.setNamespaceAware(true);
            Document doc = docBuildFactory.newDocumentBuilder().parse(new InputSource(new StringReader(message)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String xPathString = "/descendant::*[local-name()='Nutzdaten']/descendant::*";
            Node node = (Node) xPath.evaluate(xPathString, doc, XPathConstants.NODE);
            if (node != null) {
                messageType = node.getLocalName();
            } else {
                xPathString = "/descendant::*[local-name()='Mitteilung']";
                node = (Node) xPath.evaluate(xPathString, doc, XPathConstants.NODE);
                if (node != null) {
                    messageType = node.getLocalName();
                }
            }
        } catch (XPathExpressionException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SAXException ex) {
            //Möglicherweise ist es keine XML Nachricht, die ankommt, daher wird dieser Fehler nicht behandelt
            return messageType;
        } catch (IOException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return messageType;
    }

    /**
     * Erkennt via XPath den Absender einer Nachricht
     * @param message
     * @return den Absender oder "unbekannt"
     */
    public static String detectMessageSender(String message) {
        String sender = "unbekannt";
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            docBuildFactory.setNamespaceAware(true);
            Document doc = docBuildFactory.newDocumentBuilder().parse(new InputSource(new StringReader(message)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String xPathString = "/descendant::*[local-name()='Absender']/descendant::*[local-name()='BehoerdlicheNr']";
            Node node = (Node) xPath.evaluate(xPathString, doc, XPathConstants.NODE);
            if (node != null) {
                sender = node.getTextContent();
            }
        } catch (XPathExpressionException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SAXException ex) {
            //Möglicherweise ist es keine XML Nachricht, die ankommt, daher wird dieser Fehler nicht behandelt
            return sender;
        } catch (IOException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return sender;
    }

    /**
     * Erkennt via XPath den Empfänger einer Nachricht
     * @param message
     * @return den Absender oder "unbekannt"
     */
    public static String detectMessageReceiver(String message) {
        String receiver = "unbekannt";
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            docBuildFactory.setNamespaceAware(true);
            Document doc = docBuildFactory.newDocumentBuilder().parse(new InputSource(new StringReader(message)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String xPathString = "/descendant::*[local-name()='Empfaenger']/descendant::*[local-name()='BehoerdlicheNr']";
            Node node = (Node) xPath.evaluate(xPathString, doc, XPathConstants.NODE);
            if (node != null) {
                receiver = node.getTextContent();
            }
        } catch (XPathExpressionException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SAXException ex) {
            //Möglicherweise ist es keine XML Nachricht, die ankommt, daher wird dieser Fehler nicht behandelt
            return receiver;
        } catch (IOException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(ZKSMessageUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        return receiver;
    }

    /**
     * Berechnet Prüfziffern für Nummern
     * Algorithmus nach Spezifikation S.108ff.
     * @param s Der String aus dem die Prüfziffer berechnet wird
     * @return Prüfziffer die in das Dokument eingefügt wird
     */
    public static String getPruefziffer(String s) {
        String ziffer = "";
        int x = 0;
        int summe = 0;
        for (int i = 0; i < s.length(); i++) {
            x = s.charAt(i);
            if ((i % 2) != 0) {
                x = x * 5;
            }
            int quersumme = 0;
            while (x > 0) {
                quersumme += x % 10;
                x = x / 10;
            }
            summe = summe + quersumme;
        }
        summe = summe % 10;
        summe = 9 - summe;
        ziffer = ziffer + summe;
        return ziffer;
    }
}
