/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 *
 * FH Trier, Umwelt-Campus Birkenfeld
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices;

import de.zksabfall.service.ws.ServiceModulWSLocator;
import de.zksabfall.service.ws.ServiceModulWSPortType;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import javax.xml.rpc.ServiceException;

/**
 * Klasse für den ZKS-Webservice
 * @author Marc Beck
 */
public class ZKSWebservice {

    /**
     * Der Webservice zum Versenden und Empfangen von Adressnachrichten
     * (Adressanforderung, Adressanfrage, Adressantwort und Adressauskunft).
     * Diser ist (momentan) fest mit der Testumgebung verbunden.
     * Soll stattdessen die Produktivumgebung genutzt werden, muss die
     * Biblithek "zks-webservice.jar" ausgetauscht werden. Diese enthält die Klassen,
     * die aus der WSDL der Testumgebung generiert wurden.
     * @param message
     * @return
     */
    public String sendAdressnachricht(String message) {

        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier() {

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
        ServiceModulWSLocator service = new ServiceModulWSLocator();
        ServiceModulWSPortType port;
        String result = null;
        try {
            port = service.getServiceModulWSSOAP11port_http();
            result = port.verarbeite_AdressNachricht(message);
        } catch (RemoteException ex) {
            Logger.getLogger(ZKSWebservice.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ServiceException ex) {
            Logger.getLogger(ZKSWebservice.class.getName()).log(Level.SEVERE, null, ex);
        }
        return result;
    }
}
