/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.data.dao;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

/**
 * Persistence Manager Singleton<br>
 * Hält die EntityManagerFactory vor.
 * Wird verwendet, um eine mehrfache Erzeugung
 * der EMF zu verhindern.
 * @author Marc Beck
 */
public final class PersistenceManager {

    private static volatile PersistenceManager manager;
    private EntityManagerFactory emf;
    public static final String DBNAME = "/db/eanv-adapter.data.db";
    public static final String USERHOME = System.getProperty("user.home");

    /**
     * Liefert den PersistenceManager
     * @return
     */
    public static PersistenceManager getInstance() {
        if (manager == null) {
            synchronized (PersistenceManager.class) {
                if (manager == null) {
                    manager = new PersistenceManager();
                }
            }
        }
        return manager;
    }

    /**
     * Privater Konstruktor
     */
    private PersistenceManager() {
        File dbPath = new File(USERHOME + DBNAME);
        //If DB exists normal PU can be used
        if (dbPath.exists()) {
            emf = Persistence.createEntityManagerFactory("adapterPU");
        } else {
            //if not tables must be created
            Map map = new HashMap();
            map.put("eclipselink.ddl-generation", "create-tables");
            emf = Persistence.createEntityManagerFactory("adapterPU", map);
        }
    }

    /**
     * Liefert die EntityManagerFactory
     * @return
     */
    public EntityManagerFactory getEntityManagerFactory() {
        return emf;
    }
}
