/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.data.model;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.listeners.TimestampListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/**
 *
 * @author Timo Johann & Marc Beck
 */
@Entity
@EntityListeners(TimestampListener.class)
@NamedQueries({
    @NamedQuery(name = "Company.findAll", query = "Select c from Company c"),
    @NamedQuery(name = "Company.findByName", query = "Select c from Company c where c.name=?1")})
public class Company implements Serializable, Timestampable {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    @Column(nullable = false, unique = true)
    private String name;
    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(name = "adressof")
    private List<Address> addresses = new ArrayList<Address>();
    @OneToMany(cascade = CascadeType.ALL, orphanRemoval = true)
    @JoinColumn(name = "contactof")
    private List<Address> contacts = new ArrayList<Address>();
    @OneToOne(optional = true)
    private Address defaultAddress;
    @OneToOne(cascade = CascadeType.ALL, fetch = FetchType.EAGER)
    private ZKSConfiguration zKSConfig = new ZKSConfiguration();
    @Embedded
    private Timestamps timestamps = new Timestamps();
    @OneToMany
    @JoinColumn(name = "company")
    private List<OSCIErrorLog> oSCIErrorLogs = new ArrayList<OSCIErrorLog>();

    public Company() {
    }

    public Company(String name) {
        this.name = name;
    }

    public List<Address> getAddresses() {
        return addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public List<Address> getContacts() {
        return contacts;
    }

    public void setContacts(List<Address> contacts) {
        this.contacts = contacts;
    }

    public Address getDefaultAddress() {
        return defaultAddress;
    }

    public void setDefaultAddress(Address defaultAddress) {
        this.defaultAddress = defaultAddress;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<OSCIErrorLog> getoSCIErrorLogs() {
        return oSCIErrorLogs;
    }

    public void setoSCIErrorLogs(List<OSCIErrorLog> oSCIErrorLogs) {
        this.oSCIErrorLogs = oSCIErrorLogs;
    }

    public ZKSConfiguration getzKSConfig() {
        return zKSConfig;
    }

    public void setzKSConfig(ZKSConfiguration zKSConfig) {
        this.zKSConfig = zKSConfig;
    }

    public Long getId() {
        return id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof Company)) {
            return false;
        }
        Company other = (Company) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "Company[id=" + id + "]";
    }

    @Override
    public void setTimestamps(Timestamps timestamps) {
        this.timestamps = timestamps;
    }

    @Override
    public Timestamps getTimestamps() {
        return timestamps;
    }
}
