/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.data.model;

/**
 *
 * @author Timo Johann & Marc Beck
 */
public enum RoleType {

    /**
     * RoleType des Erzeuger
     */
    Erzeuger {

        @Override
        public String toString() {
            return "ERZ";
        }
    },
    /**
     * RoleType des Beförderers oder Sammlers
     */
    Beförderer {

        @Override
        public String toString() {
            return "BEF";
        }
    },
    /**
     * RoleType des Entsorgers
     */
    Entsorger {

        @Override
        public String toString() {
            return "ENT";
        }
    },
    /**
     * RoleType des logischen Zwischenlagers oder Umschlages
     */
    Zwischenlager {

        @Override
        public String toString() {
            return "ZWL";
        }
    },
    /**
     * RoleType der Behörde
     */
    Behoerde {

        @Override
        public String toString() {
            return "BEH";
        }
    },
    /**
     * RoleType des Maklers
     */
    Makler {

        @Override
        public String toString() {
            return "MAK";
        }
    },
    /**
     * RoleType des Bevollmächtigten des Erzeugers
     */
    Bevollmaechtigter {

        @Override
        public String toString() {
            return "BEVERZ";
        }
    },
    /**
     * RoleType des Providers
     */
    Provider {

        @Override
        public String toString() {
            return "PROV";
        }
    },
    /**
     * RoleType eines sonstigen Teilnehmers, falls vorhandene Rollen nicht zutreffen
     */
    Sonstiger {

        @Override
        public String toString() {
            return "SONST";
        }
    };

    public static RoleType getRolleByKurzBezeichnung(String kurzBezeichnung) {
        for (RoleType rolle : RoleType.values()) {
            if (rolle.toString().equals(kurzBezeichnung)) {
                return rolle;
            }

        }
        return null;

    }
}


