/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.data.model;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.listeners.TimestampListener;
import java.io.Serializable;
import javax.persistence.CascadeType;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;

/**
 *
 * @author Timo Johann & Marc Beck
 */
@Entity
@EntityListeners(TimestampListener.class)
@NamedQueries({
    @NamedQuery(name = "ZKSConfiguration.findAll", query = "Select z from ZKSConfiguration z")})
public class ZKSConfiguration implements Serializable, Timestampable {

    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    private Long id;
    private String registerNumber;
    private String addressIntermed;
    private String serviceLink;
    private String contactPerson;
    private String xsdLocation;
    @OneToOne(cascade = CascadeType.ALL)
    private Certificate certificateServicemodul;
    @OneToOne(cascade = CascadeType.ALL)
    private Certificate certificateIntermed;
    private RoleType roleTypeZKS = RoleType.Provider;
    @Embedded
    private Timestamps timestamps = new Timestamps();

    public String getAddressIntermed() {
        return addressIntermed;
    }

    public void setAddressIntermed(String addressIntermed) {
        this.addressIntermed = addressIntermed;
    }

    public Certificate getCertificateIntermed() {
        return certificateIntermed;
    }

    public void setCertificateIntermed(Certificate certificateIntermed) {
        this.certificateIntermed = certificateIntermed;
    }

    public Certificate getCertificateServicemodul() {
        return certificateServicemodul;
    }

    public void setCertificateServicemodul(Certificate certificateServicemodul) {
        this.certificateServicemodul = certificateServicemodul;
    }

    public String getContactPerson() {
        return contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getRegisterNumber() {
        return registerNumber;
    }

    public void setRegisterNumber(String registerNumber) {
        this.registerNumber = registerNumber;
    }

    public RoleType getRoleTypeZKS() {
        return roleTypeZKS;
    }

    public void setRoleTypeZKS(RoleType roleTypeZKS) {
        this.roleTypeZKS = roleTypeZKS;
    }

    public String getServiceLink() {
        return serviceLink;
    }

    public void setServiceLink(String serviceLink) {
        this.serviceLink = serviceLink;
    }

    public String getXsdLocation() {
        return xsdLocation;
    }

    public void setXsdLocation(String xsdLocation) {
        this.xsdLocation = xsdLocation;
    }

    @Override
    public Timestamps getTimestamps() {
        return timestamps;
    }

    @Override
    public void setTimestamps(Timestamps timestamps) {
        this.timestamps = timestamps;
    }

    public Long getId() {
        return id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        hash += (id != null ? id.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object object) {
        // TODO: Warning - this method won't work in the case the id fields are not set
        if (!(object instanceof ZKSConfiguration)) {
            return false;
        }
        ZKSConfiguration other = (ZKSConfiguration) object;
        if ((this.id == null && other.id != null) || (this.id != null && !this.id.equals(other.id))) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "ZKSConfiguration[id=" + id + "]";
    }
}
