/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 *
 * FH Trier, Umwelt-Campus Birkenfeld
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.data.model.listeners;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;

/**
 * EntityListener zum Setzen der Gültigkeitsdaten von Public-Zertifikaten
 * @author Marc Beck
 */
public final class CertificateListener {

    @PrePersist
    @PreUpdate
    public void setDates(Certificate c) {
        //FIXME: This damn thing gets called twice PreUpdate and does a dirty read on the second time :( !
        if (c.getCertificate() != null) {
            X509Certificate certificate = getCertificate(c.getCertificate());
            if (c.getPassword() == null | "".equals(c.getPassword())) {
                if (certificate != null) {
                    c.setValidFrom(certificate.getNotBefore());
                    c.setValidUntil(certificate.getNotAfter());
                }
            }
        }
    }

    /**
     * Liefert ein Zertifikat
     * @param cert
     * @return
     */
    public X509Certificate getCertificate(byte[] cert) {
        try {
            X509Certificate certificate = de.osci.helper.Tools.createCertificate(cert);
            return certificate;
        } catch (CertificateException ex) {
            //egal
            return null;
        }
    }
}
