/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.util.jaxb.ZKSNamespacePrefixMapper;
import java.io.ByteArrayOutputStream;
import java.util.UUID;
import javax.xml.bind.PropertyException;

/**
 *
 * @author Marc Beck
 */
public abstract class AbstractZKSMessageGenerator implements ZKSMessageGenerator {

    /**
     * Generiert die Nachricht
     * @param dataContainer 
     * @return a ByteArray with the UTF-8 encoded Message
     */
    @Override
    public final byte[] generateMessage(MessageDataContainer dataContainer) {
        uri.bmu_waste_interface.message.ObjectFactory messageObjectFactory = new uri.bmu_waste_interface.message.ObjectFactory();
        //Nachricht erzeugen
        uri.bmu_waste_interface.message.Nachricht nachricht = messageObjectFactory.createNachricht();
        //Status (immer ORI = Original)
        nachricht.setNachrichtenstatus("ORI");
        //Typ 4 UUID erzeugen
        nachricht.setMsgUUID(UUID.randomUUID().toString());
        //Spezifikationsversion
        nachricht.setSpezifikationsversion("1.04");
        //Kopfdaten
        uri.bmu_waste_interface.message.KopfdatenTyp kopfdatenTyp = messageObjectFactory.createKopfdatenTyp();
        uri.bmu_waste_interface.bibliothek.ObjectFactory libObjectFactory = new uri.bmu_waste_interface.bibliothek.ObjectFactory();
        //ZugangTyp des Absenders
        uri.bmu_waste_interface.bibliothek.ZugangTyp zugangTyp = libObjectFactory.createZugangTyp();
        zugangTyp.setZugangstyp("OSCI");
        uri.bmu_waste_interface.bibliothek.ZugangTyp.Struktur struktur = libObjectFactory.createZugangTypStruktur();
        //Behoerdliche Nummer des Absenders
        uri.bmu_waste_interface.bibliothek.ZugangTyp.Struktur.BehoerdlicheNummer behoerdlicheNummer = libObjectFactory.createZugangTypStrukturBehoerdlicheNummer();
        behoerdlicheNummer.setATBRolle(dataContainer.getSenderRolle());
        behoerdlicheNummer.setBehoerdlicheNr(dataContainer.getSenderBehNummer());
        behoerdlicheNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(dataContainer.getSenderBehNummer()));
        struktur.setBehoerdlicheNummer(behoerdlicheNummer);
        //Evtl. Providerdaten setzen
        if (dataContainer.getSenderProviderNummer() != null && !"".equals(dataContainer.getSenderProviderNummer())) {
            uri.bmu_waste_interface.bibliothek.ZugangTyp.Struktur.Provider provider = libObjectFactory.createZugangTypStrukturProvider();
            provider.setATBRolle(dataContainer.getSenderProviderRolle());
            provider.setBehoerdlicheNr(dataContainer.getSenderProviderNummer());
            provider.setPruefziffer(ZKSMessageUtil.getPruefziffer(dataContainer.getSenderProviderNummer()));
            struktur.setProvider(provider);
        }
        zugangTyp.setStruktur(struktur);
        kopfdatenTyp.setAbsender(zugangTyp);
        nachricht.setKopfdaten(kopfdatenTyp);
        //Nutzdaten
        nachricht.setNutzdaten(generateNutzdaten(dataContainer));
        //Nachricht erstellt!
        //Marshallen...
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            javax.xml.bind.JAXBContext jaxbCtx = javax.xml.bind.JAXBContext.newInstance(nachricht.getClass().getPackage().getName());
            javax.xml.bind.Marshaller marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_ENCODING, "UTF-8"); //NOI18N
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new ZKSNamespacePrefixMapper());
                marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_SCHEMA_LOCATION, "uri:BMU_Waste_Interface/Message Nachricht.xsd");
            } catch (PropertyException e) {
                java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, e); //NOI18N
            }
            marshaller.marshal(nachricht, bout);
        } catch (javax.xml.bind.JAXBException ex) {
            // XXXTODO Handle exception
            java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, ex); //NOI18N
        }
        return bout.toByteArray();

    }

    /**
     * Von den ableitenden Klassen zu implementierende Nutzdaten-Generierung
     * @param dataContainer 
     * @return
     */
    protected abstract uri.bmu_waste_interface.message.Nachricht.Nutzdaten generateNutzdaten(MessageDataContainer dataContainer);
}
