/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanforderungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import java.util.UUID;

/**
 * Klasse zum Generieren von Adressanforderungen
 * @author Marc Beck
 */
public class AdressanforderungGenerator extends AbstractZKSMessageGenerator {

    @Override
    protected uri.bmu_waste_interface.message.Nachricht.Nutzdaten generateNutzdaten(MessageDataContainer dataContainer) {
        AdressanforderungDataContainer container = (AdressanforderungDataContainer) dataContainer;
        uri.bmu_waste_interface.message.ObjectFactory messageObjectFactory = new uri.bmu_waste_interface.message.ObjectFactory();
        uri.bmu_waste_interface.message.Nachricht.Nutzdaten nutzdaten = messageObjectFactory.createNachrichtNutzdaten();
        //ZKS ObjectFactory
        uri.bmu_waste_interface.zks.ObjectFactory zksObjectFactory = new uri.bmu_waste_interface.zks.ObjectFactory();
        //AdressanforderungTyp
        uri.bmu_waste_interface.zks.AdressanforderungTyp adressanforderungTyp = zksObjectFactory.createAdressanforderungTyp();
        //Spezifikationsversion
        adressanforderungTyp.setSpezifikationsversion("1.04");
        //Typ 4 UUID
        adressanforderungTyp.setAnforderungUUID(UUID.randomUUID().toString());
        //Provider Nummer
        if (container.getProviderNummer() != null) {
            uri.bmu_waste_interface.zks.AdressanforderungTyp.ProviderNummer providerNummer = zksObjectFactory.createAdressanforderungTypProviderNummer();
            providerNummer.setATBRolle(container.getProviderATBRolle());
            providerNummer.setBehoerdlicheNr(container.getProviderNummer());
            providerNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getProviderNummer()));
            adressanforderungTyp.setProviderNummer(providerNummer);
        }
        //Behördliche Nummer (der Firma)
        if (container.getBehoerdlicheNummer() != null) {
            uri.bmu_waste_interface.zks.AdressanforderungTyp.BehoerdlicheNummer behoerdlicheNummer = zksObjectFactory.createAdressanforderungTypBehoerdlicheNummer();
            behoerdlicheNummer.setATBRolle(container.getAtbRolle());
            behoerdlicheNummer.setBehoerdlicheNr(container.getBehoerdlicheNummer());
            behoerdlicheNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getBehoerdlicheNummer()));
            adressanforderungTyp.setBehoerdlicheNummer(behoerdlicheNummer);
        }
        nutzdaten.setAdressanforderung(adressanforderungTyp);
        return nutzdaten;
    }
}
