/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanfrageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import java.util.UUID;

/**
 * Klasse zum Generieren einer Adressanfrage
 * @author Marc Beck
 */
public class AdressanfrageGenerator extends AbstractZKSMessageGenerator {

    @Override
    protected uri.bmu_waste_interface.message.Nachricht.Nutzdaten generateNutzdaten(MessageDataContainer dataContainer) {
        AdressanfrageDataContainer container = (AdressanfrageDataContainer) dataContainer;
        uri.bmu_waste_interface.message.ObjectFactory messageObjectFactory = new uri.bmu_waste_interface.message.ObjectFactory();
        uri.bmu_waste_interface.message.Nachricht.Nutzdaten nutzdaten = messageObjectFactory.createNachrichtNutzdaten();

        //ZKS ObjectFactory
        uri.bmu_waste_interface.zks.ObjectFactory zksObjectFactory = new uri.bmu_waste_interface.zks.ObjectFactory();
        //Bibliothek ObjectFactory
        uri.bmu_waste_interface.bibliothek.ObjectFactory libObjectFactory = new uri.bmu_waste_interface.bibliothek.ObjectFactory();
        //AdressanfrageTyp
        uri.bmu_waste_interface.zks.AdressanfrageTyp adressanfrageTyp = zksObjectFactory.createAdressanfrageTyp();
        //Spezifikationsversion
        adressanfrageTyp.setSpezifikationsversion("1.04");
        //Typ 4 UUID
        adressanfrageTyp.setAnfrageUUID(UUID.randomUUID().toString());
        //Provider Nummer
        if (container.getProviderNummer() != null) {
            uri.bmu_waste_interface.zks.AdressanfrageTyp.ProviderNummer providerNummer = zksObjectFactory.createAdressanfrageTypProviderNummer();
            providerNummer.setATBRolle(container.getProviderATBRolle());
            providerNummer.setBehoerdlicheNr(container.getProviderNummer());
            providerNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getProviderNummer()));
            adressanfrageTyp.setProviderNummer(providerNummer);

        }
        //Behördliche Nummer (der Firma)
        if (container.getBehoerdlicheNummer() != null) {
            uri.bmu_waste_interface.zks.AdressanfrageTyp.BehoerdlicheNummer behoerdlicheNummer = zksObjectFactory.createAdressanfrageTypBehoerdlicheNummer();
            behoerdlicheNummer.setATBRolle(container.getAtbRolle());
            behoerdlicheNummer.setBehoerdlicheNr(container.getBehoerdlicheNummer());
            behoerdlicheNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getBehoerdlicheNummer()));
            adressanfrageTyp.setBehoerdlicheNummer(behoerdlicheNummer);
        }
        //FirmaNameUndAdresse
        uri.bmu_waste_interface.zks.AdressanfrageTyp.FirmaNameUndAdresse firmaNameUndAdresse = zksObjectFactory.createAdressanfrageTypFirmaNameUndAdresse();
        uri.bmu_waste_interface.bibliothek.NameTyp nameTyp = libObjectFactory.createNameTyp();
        nameTyp.setName1(container.getFirmaName1());
        nameTyp.setName2(container.getFirmaName2());
        nameTyp.setName3(container.getFirmaName3());
        nameTyp.setName4(container.getFirmaName4());
        firmaNameUndAdresse.setName(nameTyp);
        uri.bmu_waste_interface.bibliothek.AdresseTyp adresseTyp = libObjectFactory.createAdresseTyp();
        adresseTyp.setStrasse1(container.getFirmaStrasse1());
        adresseTyp.setStrasse2(container.getFirmaStrasse2());
        adresseTyp.setHausnummer(container.getFirmaHausnummer());
        adresseTyp.setOrt1(container.getFirmaOrt1());
        adresseTyp.setOrt2(container.getFirmaOrt2());
        adresseTyp.setPostleitzahl(container.getFirmaPostleitzahl());
        adresseTyp.setStaat(container.getFirmaStaat());
        firmaNameUndAdresse.setAdresse(adresseTyp);
        //Ggf. Postfach-Adresse setzen
        if (container.getFirmaPostfach() != null) {
            uri.bmu_waste_interface.bibliothek.PostfachadresseTyp postfachadresseTyp = libObjectFactory.createPostfachadresseTyp();
            postfachadresseTyp.setOrt1(container.getFirmaOrt1());
            postfachadresseTyp.setOrt2(container.getFirmaOrt2());
            postfachadresseTyp.setPostfach(container.getFirmaPostfach());
            postfachadresseTyp.setPostleitzahl(container.getFirmaPostleitzahl());
            postfachadresseTyp.setStaat(container.getFirmaPostleitzahl());
            firmaNameUndAdresse.setPostfach(postfachadresseTyp);
        }
        adressanfrageTyp.setFirmaNameUndAdresse(firmaNameUndAdresse);
        //BetriebNameUndAdresse
        uri.bmu_waste_interface.zks.AdressanfrageTyp.BetriebNameUndAdresse betriebNameUndAdresse = zksObjectFactory.createAdressanfrageTypBetriebNameUndAdresse();
        uri.bmu_waste_interface.bibliothek.NameTyp betriebNameTyp = libObjectFactory.createNameTyp();
        betriebNameTyp.setName1(container.getBetriebName1());
        betriebNameTyp.setName2(container.getBetriebName2());
        betriebNameTyp.setName3(container.getBetriebName3());
        betriebNameTyp.setName4(container.getBetriebName4());
        betriebNameUndAdresse.setName(betriebNameTyp);
        uri.bmu_waste_interface.bibliothek.AdresseTyp betriebAdresseTyp = libObjectFactory.createAdresseTyp();
        betriebAdresseTyp.setStrasse1(container.getBetriebStrasse1());
        betriebAdresseTyp.setStrasse2(container.getBetriebStrasse2());
        betriebAdresseTyp.setHausnummer(container.getBetriebHausnummer());
        betriebAdresseTyp.setOrt1(container.getBetriebOrt1());
        betriebAdresseTyp.setOrt2(container.getBetriebOrt2());
        betriebAdresseTyp.setPostleitzahl(container.getBetriebPostleitzahl());
        betriebAdresseTyp.setStaat(container.getBetriebStaat());
        betriebNameUndAdresse.setAdresse(betriebAdresseTyp);
        //Ggf. Betrieb-Postfach setzen
        if (container.getBetriebPostfach() != null) {
            uri.bmu_waste_interface.bibliothek.PostfachadresseTyp postfachadresseTyp = libObjectFactory.createPostfachadresseTyp();
            postfachadresseTyp.setOrt1(container.getBetriebOrt1());
            postfachadresseTyp.setOrt2(container.getBetriebOrt2());
            postfachadresseTyp.setPostfach(container.getBetriebPostfach());
            postfachadresseTyp.setPostleitzahl(container.getBetriebPostleitzahl());
            postfachadresseTyp.setStaat(container.getBetriebPostleitzahl());
            betriebNameUndAdresse.setPostfach(postfachadresseTyp);
        }
        adressanfrageTyp.setBetriebNameUndAdresse(betriebNameUndAdresse);
        //Indicator nur Default Adresse
        adressanfrageTyp.setIndicatorNurDefaultadresse(container.isDefaultAdresse());
        //Adressanfrage erstellt!
        nutzdaten.setAdressanfrage(adressanfrageTyp);

        return nutzdaten;
    }
}
