/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MitteilungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.util.jaxb.ZKSNamespacePrefixMapper;
import java.io.ByteArrayOutputStream;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.PropertyException;

/**
 * Generator für eine Mitteilung
 * @author Marc Beck
 */
public class MitteilungGenerator {

    /**
     * Generiert eine Mitteilung
     * @param sender
     * @param dataContainer
     * @return
     */
    public byte[] generateMessage(MessageDataContainer dataContainer) {
        MitteilungDataContainer container = (MitteilungDataContainer) dataContainer;
        uri.bmu_waste_interface.message.ObjectFactory objectFactory = new uri.bmu_waste_interface.message.ObjectFactory();
        //Mitteilung erzeugen
        uri.bmu_waste_interface.message.MitteilungsTyp mitteilung = objectFactory.createMitteilungsTyp();
        mitteilung.setSpezifikationsversion("1.04");
        //Mitteilung befüllen
        mitteilung.setBezug(container.getBezug());
        mitteilung.setZweck(container.getText());
        mitteilung.setThema(container.getThema());
        mitteilung.setText(container.getText());
        //JAXBElement erzeugen
        JAXBElement<uri.bmu_waste_interface.message.MitteilungsTyp> element = objectFactory.createMitteilung(mitteilung);

        //fertig, marshallen:
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            javax.xml.bind.JAXBContext jaxbCtx = javax.xml.bind.JAXBContext.newInstance(uri.bmu_waste_interface.message.ObjectFactory.class);
            javax.xml.bind.Marshaller marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_ENCODING, "UTF-8"); //NOI18N
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            try {
                marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new ZKSNamespacePrefixMapper());
                marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_SCHEMA_LOCATION, "uri:BMU_Waste_Interface/Message Nachricht.xsd");
            } catch (PropertyException e) {
                java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, e); //NOI18N
            }
            marshaller.marshal(element, bout);
        } catch (javax.xml.bind.JAXBException ex) {
            // XXXTODO Handle exception
            java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, ex); //NOI18N
        }
        return bout.toByteArray();
    }
}
