/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.QuittungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.util.jaxb.ZKSNamespacePrefixMapper;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;


/**
 * Generiert Quittungen
 * @author Timo
 */
public class QuittungGenerator {

    public byte[] generateQuittung(List<QuittungDataContainer> container) {

        uri.bmu_waste_interface.message.ObjectFactory factory = new uri.bmu_waste_interface.message.ObjectFactory();
        uri.bmu_waste_interface.message.QuittungTyp inhaltQuittung = factory.createQuittungTyp();
        uri.bmu_waste_interface.message.Quittung quittung = factory.createQuittung();
        uri.bmu_waste_interface.message.MeldungTyp meldung = factory.createMeldungTyp();
        List<uri.bmu_waste_interface.message.MeldungTyp> meldungen = inhaltQuittung.getMeldung();

        quittung.setSpezifikationsversion("1.04");
        quittung.setBezugMsgUUID(container.get(0).getBezugMsgUUID());
        
        //Meldungen erzeugen
        for (QuittungDataContainer dataContainer : container) {
            meldung.setAbhilfe(dataContainer.getAbhilfe());
            meldung.setBeschreibung(dataContainer.getBeschreibung());
            meldung.setCode(dataContainer.getCode());
            meldung.setKlasse(dataContainer.getFehlerklasse());
            meldung.setStufe(dataContainer.getStufe());
            meldungen.add(meldung);
        }
        

         ByteArrayOutputStream bos = new ByteArrayOutputStream();

        try {
            javax.xml.bind.JAXBContext jaxbCtx = javax.xml.bind.JAXBContext.newInstance(uri.bmu_waste_interface.message.ObjectFactory.class);
            javax.xml.bind.Marshaller marshaller = jaxbCtx.createMarshaller();
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_ENCODING, "UTF-8"); 
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", new ZKSNamespacePrefixMapper());
            marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_SCHEMA_LOCATION, "uri:BMU_Waste_Interface/Message Nachricht.xsd");
            marshaller.marshal(inhaltQuittung, bos);
        } catch (javax.xml.bind.JAXBException ex) {
            java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, ex); 
        }
        try {
            System.out.println(bos.toString("UTF-8"));
        } catch (UnsupportedEncodingException ex) {
            Logger.getLogger(QuittungGenerator.class.getName()).log(Level.SEVERE, null, ex);
        }
        return bos.toByteArray();
    }
}
