/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanforderungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanfrageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.ZKSParameterAnfrageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.ZertifikatsuebermittlungDataContainer;

/**
 *
 * @author Marc Beck
 */
public class ZKSMessageGeneratorFactory {

    /**
     * Entscheidet anhand des Datencontainers welcher Generator geliefert werden soll
     * @param dataContainer
     * @return
     */
    public ZKSMessageGenerator getGenerator(MessageDataContainer dataContainer) {
        if (dataContainer instanceof AdressanfrageDataContainer) {
            return new AdressanfrageGenerator();
        }
        if (dataContainer instanceof AdressanforderungDataContainer) {
            return new AdressanforderungGenerator();
        }
        if (dataContainer instanceof ZKSParameterAnfrageDataContainer) {
            return new ZKSParameterAnfrageGenerator();
        }
        if (dataContainer instanceof ZertifikatsuebermittlungDataContainer) {
            return new ZertifikatsuebermittlungGenerator();
        }

        return null;
    }
}
