/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.generators;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MessageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.ZKSParameterAnfrageDataContainer;

/**
 *
 * @author Marc
 */
public class ZKSParameterAnfrageGenerator extends AbstractZKSMessageGenerator {

    @Override
    protected uri.bmu_waste_interface.message.Nachricht.Nutzdaten generateNutzdaten(MessageDataContainer dataContainer) {
        ZKSParameterAnfrageDataContainer container = (ZKSParameterAnfrageDataContainer) dataContainer;
        uri.bmu_waste_interface.message.ObjectFactory messageObjectFactory = new uri.bmu_waste_interface.message.ObjectFactory();
        uri.bmu_waste_interface.message.Nachricht.Nutzdaten nutzdaten = messageObjectFactory.createNachrichtNutzdaten();
        //ZKS ObjectFactory
        uri.bmu_waste_interface.zks.ObjectFactory zksObjectFactory = new uri.bmu_waste_interface.zks.ObjectFactory();
        //ZKSParameterAnfrageTyp
        uri.bmu_waste_interface.zks.ZKSParameterAnfrageTyp zKSParameterAnfrageTyp = zksObjectFactory.createZKSParameterAnfrageTyp();
        //Spezifikationsversion
        zKSParameterAnfrageTyp.setSpezifikationsversion("1.04");
        //Behördliche Nummer
        uri.bmu_waste_interface.zks.ZKSParameterAnfrageTyp.BehoerdlicheNummer zksbehoerdlicheNummer = zksObjectFactory.createZKSParameterAnfrageTypBehoerdlicheNummer();
        zksbehoerdlicheNummer.setBehoerdlicheNr(container.getBehoerdlicheNummer());
        zksbehoerdlicheNummer.setATBRolle(container.getAtbRolle());
        zksbehoerdlicheNummer.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getBehoerdlicheNummer()));
        zKSParameterAnfrageTyp.setBehoerdlicheNummer(zksbehoerdlicheNummer);
        //ProviderNummer
        if (container.getProviderNummer() != null) {
            uri.bmu_waste_interface.zks.ZKSParameterAnfrageTyp.Provider zksprovider = zksObjectFactory.createZKSParameterAnfrageTypProvider();
            zksprovider.setBehoerdlicheNr(container.getProviderNummer());
            zksprovider.setATBRolle(container.getProviderATBRolle());
            zksprovider.setPruefziffer(ZKSMessageUtil.getPruefziffer(container.getProviderNummer()));
            zKSParameterAnfrageTyp.setProvider(zksprovider);
        }
        //ZKSParameteranfrage erstellt!
        nutzdaten.setZKSParameterAnfrage(zKSParameterAnfrageTyp);
        return nutzdaten;
    }
}
