/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.processors;

import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AdressantwortList;
import java.awt.Component;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.xml.sax.InputSource;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import uri.bmu_waste_interface.message.Nachricht;
import uri.bmu_waste_interface.zks.AdressantwortTyp;
import uri.bmu_waste_interface.zks.AdressantwortTyp.Liste;

/**
 *
 * @author Marc Beck
 */
public class AdressantwortProcessor extends AbstractZKSMessageProcessor {

    private List<AdressantwortBlock> adressantwortBlocks;
    private AdressantwortBlock selectedAdressantwort;

    @Override
    protected void process(String message) {
        InputSource is = new InputSource(new StringReader(message));
        Nachricht nachricht = null;
        try {
            javax.xml.bind.JAXBContext jaxbCtx = javax.xml.bind.JAXBContext.newInstance(uri.bmu_waste_interface.message.ObjectFactory.class);
            javax.xml.bind.Unmarshaller unmarshaller = jaxbCtx.createUnmarshaller();
            nachricht = (Nachricht) unmarshaller.unmarshal(is); //NOI18N
        } catch (javax.xml.bind.JAXBException ex) {
            // XXXTODO Handle exception
            java.util.logging.Logger.getLogger("global").log(java.util.logging.Level.SEVERE, null, ex); //NOI18N
        }
        //Adressantwort prozessieren
        AdressantwortTyp adressantwortTyp = nachricht.getNutzdaten().getAdressantwort();
        if (adressantwortTyp == null) {
            return;
        }
        List<Liste> listen = adressantwortTyp.getListe();
        this.adressantwortBlocks = new ArrayList<AdressantwortBlock>();
        for (Liste liste : listen) {
            String behoerdlicheNummer = liste.getBehoerdlicheNummer().getBehoerdlicheNr();
            String rolle = liste.getBehoerdlicheNummer().getATBRolle();
            String providerNummer = liste.getProviderNummer().getBehoerdlicheNr();
            String providerRolle = liste.getProviderNummer().getATBRolle();
            if (providerNummer.equals(behoerdlicheNummer)) {
                providerNummer = "";
                providerRolle = "";
            }
            String name = liste.getFirmaNameUndAdresse().getName().getName1();
            adressantwortBlocks.add(new AdressantwortBlock(providerNummer, providerRolle, behoerdlicheNummer, rolle, name));
        }
    }

    @Override
    protected void getSwingResult(Component parent) {
        if (!adressantwortBlocks.isEmpty()) {
            // Nachrichtenverfolgung anzeigen
            AdressantwortList adressantortPanel = new AdressantwortList(adressantwortBlocks);
            JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(parent));
            dialog.setContentPane(adressantortPanel);
            dialog.pack();
            dialog.setLocationRelativeTo(parent);
            dialog.setTitle("Adressantworten");
            dialog.setModal(true);
            dialog.setVisible(true);
            this.selectedAdressantwort = adressantortPanel.getAdressantwortBlock();
        } else {
            JOptionPane.showMessageDialog(parent, MessageBundle.getString("msgAdressantwortNoReply"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
        }
    }

    public AdressantwortBlock getSelectedAdressantwort() {
        return selectedAdressantwort;
    }

    public class AdressantwortBlock {

        private String providerNummer;
        private String providerRolle;
        private String behoerdlicheNummer;
        private String rolle;
        private String name;

        public AdressantwortBlock(String providerNummer, String providerRolle, String behoerdlicheNummer, String rolle, String name) {
            this.providerNummer = providerNummer;
            this.providerRolle = providerRolle;
            this.behoerdlicheNummer = behoerdlicheNummer;
            this.rolle = rolle;
            this.name = name;
        }

        public String getBehoerdlicheNummer() {
            return behoerdlicheNummer;
        }

        public String getName() {
            return name;
        }

        public String getProviderNummer() {
            return providerNummer;
        }

        public String getProviderRolle() {
            return providerRolle;
        }

        public String getRolle() {
            return rolle;
        }
    }
}
