/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.documents.processors;

import java.awt.Component;
import java.io.IOException;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc Beck
 */
public class AdressauskunftProcessor extends AbstractZKSMessageProcessor {

    private byte[] cert;

    @Override
    protected void process(String message) {
        try {
            DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
            docBuildFactory.setNamespaceAware(true);
            Document doc = docBuildFactory.newDocumentBuilder().parse(new InputSource(new StringReader(message)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            String xPathString = "/descendant::*[local-name()='Zertifikat']";
            Node node = (Node) xPath.evaluate(xPathString, doc, XPathConstants.NODE);
            if (node != null) {
                String content = node.getTextContent();
                //Präfix und Suffix für die Zertifikatsdatei
                content = "-----BEGIN CERTIFICATE-----\n" + content + "-----END CERTIFICATE-----";
                cert = content.getBytes("UTF-8");
            }
        } catch (XPathExpressionException ex) {
            Logger.getLogger(AdressauskunftProcessor.class.getName()).log(Level.SEVERE, null, ex);
        } catch (SAXException ex) {
            Logger.getLogger(AdressauskunftProcessor.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(AdressauskunftProcessor.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(AdressauskunftProcessor.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    protected void getSwingResult(Component parent) {
        if (this.cert != null) {
            JOptionPane.showMessageDialog(parent, MessageBundle.getString("msgAdressauskunftCertificateAppled"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
        } else {
            JOptionPane.showMessageDialog(parent, MessageBundle.getString("msgAdressauskunftNoCertificate"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
        }
    }

    public byte[] getCert() {
        return cert;
    }
}
