/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.main;

import de.umweltcampus.uput.informatik.openeanvadapter.view.components.MenuFrame;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard.MainPanel;
import java.awt.Font;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import static de.umweltcampus.uput.informatik.openeanvadapter.data.dao.PersistenceManager.DBNAME;
import static de.umweltcampus.uput.informatik.openeanvadapter.data.dao.PersistenceManager.USERHOME;

/**
 * Klasse zum Starten des Adapters
 * @author Marc Beck
 */
public class RunView {

    /**
     * 
     * @param args "noWizard" falls kein Wizard beim ersten Start gewünscht ist
     */
    public static void main(String... args) {
        File dbPath = new File(USERHOME + DBNAME);
        //Nimbus ist unser Standard-Look&Feel
        try {
            //Versuchen das NimbusLookAndFeel zu setzen
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            //In Nimbus sollte eine kleinere Schriftart gewählt werden.
            UIManager.put("TextField.font", new Font("SansSerif", 0, 10));
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(RunView.class.getName()).log(Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            Logger.getLogger(RunView.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            Logger.getLogger(RunView.class.getName()).log(Level.SEVERE, null, ex);
        } catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(RunView.class.getName()).log(Level.SEVERE, null, ex);
        }
        //Icon laden
        ImageIcon icon = new ImageIcon(RunView.class.getResource("/de/umweltcampus/uput/informatik/openeanvadapter/resources/icon.PNG"));

        boolean b = args.length > 0 ? args[0].equals("noWizard") : false;
        if (dbPath.exists() || b) {
            //DB existiert -> Adapter starten
            // Frame anzeigen
            JFrame frame = new MenuFrame();
            frame.setIconImage(icon.getImage());
            frame.pack();
            frame.setLocationRelativeTo(null);
            frame.setVisible(true);

        } else {
            //DB existiert nicht -> Wizard starten
            JDialog dialog = new JDialog((JFrame) null, MessageBundle.getString("WizardName"), true);
            dialog.add(new MainPanel());
            dialog.setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
            dialog.setResizable(false);
            dialog.pack();
            dialog.setLocationRelativeTo(null);
            dialog.setVisible(true);
            return;
        }
    }
}
