/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util;

import java.awt.Component;
import java.awt.Desktop;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc Beck
 */
public class FileUtil {

    /**
     * Methode zum Anzeigen einer Datei mit System-Bordmitteln.
     * <br>
     * Schreibt die Datei temporär ins Dateisystem und öffnet die dann.
     * @param data das byte[], das die Datei darstellt.
     *
     */
    public static void viewFile(byte[] data, String suffix) {
        try {
            File f = File.createTempFile("file", suffix);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(data);
            fos.flush();
            fos.close();
            Desktop.getDesktop().open(f);
        } catch (IOException ex) {
            Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /**
     * Liest eine Datei in ein byte[] ein.
     * <br>
     * Dazu wird ein FileChooser verwendet.
     * @param component die aufrufende Komponente.
     * @param suffix Dateiendung
     * @param description Beschreibung des Dateityps
     * @return
     */
    public static byte[] readFile(Component component, final String suffix, final String description) {
        byte[] bs = null;
        JFileChooser chooser = new JFileChooser();
        //Nur bestimmte Dateien zulassen
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(suffix);
            }

            @Override
            public String getDescription() {
                return description;
            }
        });
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(component) == JFileChooser.APPROVE_OPTION) {
            try {
                //Datei einlesen
                File f = chooser.getSelectedFile();
                FileInputStream fis = new FileInputStream(f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                while ((i = fis.read()) != -1) {
                    baos.write(i);
                }
                fis.close();
                baos.close();
                bs = baos.toByteArray();
            } catch (FileNotFoundException ex) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
            }

        }
        //Zurückgeben
        return bs;
    }

    /**
     * Zeigt einen typischen "Speichern unter..." Dialog an.
     * @param component
     * @param data
     * @return true wenn gespeichert wurde, false wenn nicht
     */
    public static boolean saveAs(Component component, byte[] data) {
        return saveAs(component, data, null);
    }

    /**
     * Zeigt einen typischen "Speichern unter..." Dialog an.
     * @param component
     * @param data
     * @param filename
     * @return true wenn gespeichert wurde, false wenn nicht
     */
    public static boolean saveAs(Component component, byte[] data, String filename) {
        JFileChooser chooser = new JFileChooser();
        if (filename != null) {
            chooser.setSelectedFile(new File(filename));
        }
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showSaveDialog(component) == JFileChooser.APPROVE_OPTION) {
            try {
                if (chooser.getSelectedFile() == null) {
                    return false;
                }
                File f = chooser.getSelectedFile();
                if (f.exists()) {
                    int result = JOptionPane.showConfirmDialog(component, MessageBundle.getString("msgOverwriteQuestion"), MessageBundle.getString("msgFileExists"), JOptionPane.YES_NO_OPTION);
                    if (result != JOptionPane.YES_OPTION) {
                        return false;
                    }
                }
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(data);
                fos.flush();
                fos.close();

            } catch (FileNotFoundException ex) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(FileUtil.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }
        return false;
    }
}
