/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util;

import de.umweltcampus.uput.informatik.openeanvadapter.util.common.DocumentType;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Marc Beck
 */
public class GenericUtils {

    /**
     * Methode zum erhalten einer Liste von Dokumententypen.
     * @return
     */
    public static List<String> getDokTypNames() {
        List<String> docTypNames = new ArrayList<String>();
        for (DocumentType dok : DocumentType.values()) {
            docTypNames.add(dok.name());
        }
        //Werden vorher noch sortiert
        Collections.sort(docTypNames);
        return docTypNames;
    }

    /**
     * Prüft ein privates Zertifikat gegen ein passwort
     * @param cert
     * @param password
     * @return
     */
    public static boolean checkPassword(byte[] cert, String password) {
        InputStream is = null;
        try {
            //Neuer Keystore im PKCS12-Format
            KeyStore myKeystore = KeyStore.getInstance("PKCS12");
            is = new ByteArrayInputStream(cert);
            //KeyStore laden
            myKeystore.load(is, password.toCharArray());
            //PrivateKey
            KeyStore.PasswordProtection pwd = new KeyStore.PasswordProtection(password.toCharArray());
            Enumeration<String> e = myKeystore.aliases();
            //Alias
            String alias = "";
            while (e.hasMoreElements()) {
                alias = e.nextElement();
            }
            KeyStore.PrivateKeyEntry thePrivKeyEntry = (KeyStore.PrivateKeyEntry) myKeystore.getEntry(alias, pwd);
            //Wenn bis hierhin alles gut geht, ist das Passwort richtig
            return true;
        } catch (Exception ex) {
            //ignorieren
        } finally {
            try {
                is.close();
            } catch (IOException ex) {
                Logger.getLogger(GenericUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    /**
     * Liefert zu einem Datum die String-Repräsentation im ISO8601-Format
     * @param date
     * @return
     */
    public static String getISO8601Timestamp(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String time = dateFormat.format(date);
        time = time.substring(0, 22) + ":" + time.substring(22, time.length());
        return time;
    }
}
