/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc Beck
 */
public class MessageRequirementsValidator {

    public static boolean validateZKS() {
        Company company = CompanyFacade.getCompany();
        ZKSConfiguration configuration = company.getzKSConfig();
        boolean b = true;
        if (configuration.getCertificateIntermed() == null) {
            b = false;
        }
        if (configuration.getCertificateServicemodul() == null) {
            b = false;
        }
        if (configuration.getAddressIntermed() == null | "".equals(configuration.getAddressIntermed())) {
            b = false;
        }
        if (configuration.getRegisterNumber() == null | "".equals(configuration.getRegisterNumber())) {
            b = false;
        }

        return b;
    }

    public static boolean validateCompany() {
        Company company = CompanyFacade.getCompany();
        Address address = company.getDefaultAddress();
        boolean b = true;
        if (address == null) {
            return false;
        }
        if (address.getPrivateCertificate() == null) {
            b = false;
        }
        if (address.getRegisterNumber() == null | "".equals(address.getRegisterNumber())) {
            b = false;
        }
        return b;
    }

    public static String getMessageZKS() {
        return MessageBundle.getString("msgZKSDataIncomplete");
    }

    public static String getMessageCompany() {
        return MessageBundle.getString("msgUnternehmenDataIncomplete");
    }
}
