/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util.common;

import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;

/**
 *
 * @author Timo
 *
 * Repräsentiert einen Dokumententyp
 */
public enum DocumentType {

    /**
     * Ein E N oder SN im Grundverfahren oder privilegierten Verfahren
     */
    ENSNDokument {

        @Override
        public String toString() {
            return "ENS";
        }
    },
    /**
     * Freistellungsantrag
     */
    Freistellungsantrag {

        @Override
        public String toString() {
            return "FR";
        }
    },
    /**
     * Begleitschein
     */
    Begleitschein {

        @Override
        public String toString() {
            return "BGS";
        }
    },
    /**
     * Übernahmeschein
     */
    Uebernahmeschein {

        @Override
        public String toString() {
            return "UNS";
        }
    },
    /**
     * Die Anforderung eines Registerauszugs
     */
    RegisterAnforderung {

        @Override
        public String toString() {
            return "RA";
        }
    },
    /**
     * Ein Registerauszug
     */
    RegisterAuszug {

        @Override
        public String toString() {
            return "RG";
        }
    },
    /**
     * Ein Dokument zu einer grenzüberschreitenden Abfallverbringung (EUDIN)
     */
    Abfallverbringungsdokument {

        @Override
        public String toString() {
            return "AVD";
        }
    },
    /**
     * Quittungsnachricht zu einem Dokument
     */
    Quittung {

        @Override
        public String toString() {
            return "QT";
        }
    },
    /**
     * Eine Mitteilung
     */
    Mitteilung {

        @Override
        public String toString() {
            return "MT";
        }
    },
    /**
     * Anforderung eines Nummernkontingents für BGS-,UNS-, und NWL-Nummern
     */
    BGSNrAnforderung {

        @Override
        public String toString() {
            return "NRA";
        }
    },
    /**
     * Antwort auf BGSNrAnforderung. Beihaltet das Nummernkontingent
     */
    BGSNrZuteilung {

        @Override
        public String toString() {
            return "NRZ";
        }
    },
    /**
     * Werden durch Dienstleister (Provider) verschickt.
     * Dienstleister muss registriert sein und Antrag als Providerantrag kennzeichnen.
     * Werden auch zur Veränderung von Stammdaten genutzt. (Attribut Update/Delete)
     */
    Registrierungsantrag {

        @Override
        public String toString() {
            return "RAN";
        }
    },
    /**
     * Wird nach erhalt des Registrieungsantrags von der Behörde an die ZKS erteilt.
     */
    Registrierungsauftrag {

        @Override
        public String toString() {
            return "Registrierungsauftrag";
        }
    },
    /**
     * Ein Dokument zur Übermittlung eines Verschlüsselungszertifikats
     * (vom Antragsteller an die ZKS)
     */
    Zertifikatsuebermittlung {

        @Override
        public String toString() {
            return "RZT";
        }
    },
    /**
     * Die Quittung zum Auftrag
     * (von der ZKS an den Registrierungspflichtigen)
     */
    Registrierungsquittung {

        @Override
        public String toString() {
            return "RQT";
        }
    },
    /**
     * Adressanfrage eines registrierten Betriebs bei der ZKS
     */
    Adressanfrage {

        @Override
        public String toString() {
            return "ASA";
        }
    },
    /**
     * Antwort auf Adressanfrage.
     * Liefert eine Liste der zu der Anfrage gefundenen Treffer.
     */
    Adressantwort {

        @Override
        public String toString() {
            return "ASL";
        }
    },
    /**
     * Fordert genau einen Adresseintrag der ZKS an
     */
    Adressanforderung {

        @Override
        public String toString() {
            return "AST";
        }
    },
    /**
     * Übermittelt das zu der Adressanforderung passende Zertifikat
     */
    Adressauskunft {

        @Override
        public String toString() {
            return "ASZ";
        }
    },
    /**
     * Der Bearbeitungsauftrag ist für behördeninterne Zwecke vorgesehen.
     * Beinhaltet die Informationen, wer den Auftrag abgegeben hat, die Auftragsart
     * und den Auftragsgegenstand (BMU-XML-Dokument)
     */
    ZKSAuftrag {

        @Override
        public String toString() {
            return "ZKSAuftrag";
        }
    },
    /**
     * Antwort auf ZKSAuftrag, von ZKS erstellt. Enthält die Auftragskennung
     * und je (Teil-) Auftrag eine Liste von Meldungen.
     */
    ZKSErgebnis {

        @Override
        public String toString() {
            return "ZKSErgebnis";
        }
    },
    /**
     * Abfrage der gesetzten Parameter durch Administratoren und Betreiber der ZKS
     */
    ZKSParameterAnfrage {

        @Override
        public String toString() {
            return "PAN";
        }
    },
    /**
     * Antwort auf ZKS-Parameterabfrage
     */
    ZKSParameterErgebnis {

        @Override
        public String toString() {
            return "PAT";
        }
    },
    /**
     * Sonderform des Begleitscheins für die Nachweisführung über zurückgenommene Abfälle
     * im Rahmen der freiwilligen Rücknahme nach §25 KrW-/AbfG.
     *
     * Keine Layertechnik.
     * Dokumentiert nicht den einzelnen Transport, sondern die durch einen Produzenten
     * oder Vertreiber zurückgenommene Abfallmenge für einen Zeitraum.
     */
    Nachweisliste {

        @Override
        public String toString() {
            return "NWL";
        }
    },
    /**
     * Ein ergänzendes Formblatt zum Nachweis für Bevollmächtigung
     * und Beauftragung
     */
    ErgaenzendesFormblatt {

        @Override
        public String toString() {
            return "EGF";
        }
    },
    /**
     * Ein Bescheid der AGS zum ergänzenden Formblatt
     */
    AGSBescheid {

        @Override
        public String toString() {
            return "EGB";
        }
    },
    /**
     * Eine Deklarationsanalyse
     */
    Deklarationsanalyse {

        @Override
        public String toString() {
            return "DAD";
        }
    };

    public static Collection<DocumentType> getSortedValues() {
        SortedMap<String, DocumentType> map = new TreeMap<String, DocumentType>();
        for (DocumentType d : DocumentType.values()) {
            map.put(d.name(), d);
        }
        return map.values();
    }
}
