/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util.common;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;

/**
 * TODO: Needs work...
 * @author mm0013
 */
public class Profil {

    private String empfaenger;
    private RoleType empfaengerRoleType;
    private String absender;
    private RoleType absenderRoleType;
    private DocumentType dokumentTyp;
    private String formularNummer;

    /**
     * Erzeugt ein leeres Profil-Objekt
     */
    public Profil() {
    }

    /**
     * Erzeugt ein Profilobjekt unter Verwendung eines Profilstrings zum Befüllen der Werte
     * @param aProfilString Der Profilstring aus dem die Werte für das Profilobjekt gewonnen werden
     */
    public Profil(String aProfilString) throws CommonException {

        this.setEmpfaenger(aProfilString.substring(0, 10));
        this.setAbsender(aProfilString.substring(16, 26));
        this.setFormularNummer(aProfilString.substring(35, 50));

        String ERoleType = aProfilString.substring(10, 16).trim();
        String ARoleType = aProfilString.substring(26, 32).trim();
        String DT = aProfilString.substring(32, 35).trim();

        for (RoleType r : RoleType.values()) {
            if (r.toString().equals(ERoleType)) {
                this.setEmpfaengerRoleType(r);
            }
            if (r.toString().equals(ARoleType)) {
                this.setAbsenderRoleType(r);
            }
        }

        if (this.empfaengerRoleType == null) {
            throw new CommonException("Das Kürzel für die Empfängerrolle ist unbekannt");
        }

        if (this.absenderRoleType == null) {
            throw new CommonException("Das Kürzel für die Absenderrolle ist unbekannt");
        }

        for (DocumentType dt : DocumentType.values()) {
            if (dt.toString().equals(DT)) {
                this.setDokumentTyp(dt);
                break;
            }
        }

        if (this.dokumentTyp == null) {
            throw new CommonException("Das Kürzel für den DokumentTyp ist unbekannt");
        }
    }

    /**
     * Erzeugt ein Profil-Objekt und füllt dieses mit den übergebenen Profilierungsdaten
     * @param aEmpfaenger Der Empfänger
     * @param aEmpfaengerRoleType Die RoleType des Empfängers
     * @param aAbsender Der Absender
     * @param aAbsenderRoleType Die RoleType des Absenders
     * @param aDokumentTyp Der Dokumenttyp
     * @param aFormularnummer Die 15-stellige Formularnummer
     */
    public Profil(String aEmpfaenger, RoleType aEmpfaengerRoleType, String aAbsender, RoleType aAbsenderRoleType, DocumentType aDokumentTyp, String aFormularnummer) throws CommonException {
        if (!aEmpfaenger.trim().isEmpty()) {
            this.empfaenger = aEmpfaenger;
        } else {
            throw new CommonException("Der Empfänger darf nicht leer sein");
        }

        if (aEmpfaengerRoleType != null) {
            this.empfaengerRoleType = aEmpfaengerRoleType;
        } else {
            throw new CommonException("Die Empfängerrolle darf nicht null sein");
        }


        if (!aAbsender.trim().isEmpty()) {
            this.absender = aAbsender;
        } else {
            throw new CommonException("Der Absender darf nicht leer sein");
        }


        if (!aAbsenderRoleType.equals(null)) {
            this.absenderRoleType = aAbsenderRoleType;
        } else {
            throw new CommonException("Die Absenderrolle darf nicht null sein");
        }


        if (aDokumentTyp != null) {
            this.dokumentTyp = aDokumentTyp;
        } else {
            throw new CommonException("Der Dokument-Typ darf nicht null sein");
        }

        if (!aFormularnummer.isEmpty()) {
            this.formularNummer = aFormularnummer;
        } else {
            throw new CommonException("Die Formularnummer darf nicht leer sein");
        }

    }

    /**
     * Weist dem Profil einen Empfänger zu
     * @param aEmpfaenger Der Empfänger, der dem Profil zugewiesen werden soll
     */
    public void setEmpfaenger(String aEmpfaenger) throws CommonException {
        if (!aEmpfaenger.trim().isEmpty()) {
            this.empfaenger = aEmpfaenger;
        } else {
            throw new CommonException("Der Empfänger darf nicht leer sein");
        }
    }

    /**
     * Liefert den Empfänger
     * @return Ein Empfänger
     */
    public String getEmpfaenger() throws CommonException {
        if (!this.empfaenger.trim().isEmpty()) {
            return this.empfaenger;
        } else {
            throw new CommonException("Der Empfänger ist leer");
        }

    }

    /**
     * Weist dem Empfänger im Profil eine RoleType zu
     * @param aEmpfaengerRoleType Die RoleType, die dem Empfänger im Profil zugewiesen werden woll
     * @see RoleType
     */
    public void setEmpfaengerRoleType(RoleType aEmpfaengerRoleType) throws CommonException {

        if (!aEmpfaengerRoleType.equals(null)) {
            this.empfaengerRoleType = aEmpfaengerRoleType;
        } else {
            throw new CommonException("Die Empfängerrolle darf nicht null sein");
        }
    }

    /**
     * Liefert die Empfängerrolle
     * @return Eine Empfängerrolle
     * @see RoleType
     */
    public RoleType getEmpfaengerRoleType() throws CommonException {
        if (this.absenderRoleType != null) {
            return this.empfaengerRoleType;
        } else {
            throw new CommonException("Es existiert keine Empfängerrolle");
        }
    }

    /**
     * Weist dem Profil einen Absender zu
     * @param aAbsender Der Absender, der dem Profil zugewiesen werden soll
     */
    public void setAbsender(String aAbsender) throws CommonException {
        if (!aAbsender.trim().isEmpty()) {
            this.absender = aAbsender;
        } else {
            throw new CommonException("Der Absender darf nicht leer sein");
        }
    }

    /**
     * Liefert den Absender
     * @return Ein Absender
     */
    public String getAbsender() throws CommonException {
        if (!this.absender.trim().isEmpty()) {
            return this.absender;
        } else {
            throw new CommonException("Der Absender ist leer");
        }
    }

    /**
     * Weist dem Absender im Profil eine RoleType zu
     * @param aAbsenderRoleType Die RoleType, die dem Absender im Profil zugewiesen werden woll
     * @see RoleType
     */
    public void setAbsenderRoleType(RoleType aAbsenderRoleType) throws CommonException {

        if (aAbsenderRoleType != null) {
            this.absenderRoleType = aAbsenderRoleType;
        } else {
            throw new CommonException("Die Absenderrolle darf nicht null sein");
        }

    }

    /**
     * Liefert die Absenderrolle
     * @return Eine Absenderrolle
     * @see RoleType
     */
    public RoleType getAbsenderRoleType() throws CommonException {
        if (this.absenderRoleType != null) {
            return this.absenderRoleType;
        } else {
            throw new CommonException("Ex existiert keine Absenderolle");
        }
    }

    /**
     * Weist dem Profil einen Dokumenttyp zu
     * @param aDokumentTyp Der dem Profil zuzuweisenden Dokumenttyp
     * @see DocumentType
     */
    public void setDokumentTyp(DocumentType aDokumentTyp) throws CommonException {

        if (aDokumentTyp != null) {
            this.dokumentTyp = aDokumentTyp;
        } else {
            throw new CommonException("Der Dokument-Typ darf nicht null sein");
        }

    }

    /**
     * Liefert den Dokumenttyp zurück
     * @return Ein Dokumenttyp
     * @see DocumentType
     */
    public DocumentType getDokumentTyp() throws CommonException {
        if (this.dokumentTyp != null) {
            return this.dokumentTyp;
        } else {
            throw new CommonException("Es existiert kein Dokumenttyp");
        }
    }

    /**
     * Weist dem Profil eine 15-stellige Formularnummer zu
     * @param aFormularnummer Die dem Profil hinzuzufügende Formularnummer
     */
    public void setFormularNummer(String aFormularnummer) throws CommonException {
        if (!aFormularnummer.isEmpty()) {
            this.formularNummer = aFormularnummer;
        } else {
            throw new CommonException("Die Formularnummer darf nicht leer sein");
        }
    }

    /**
     * Liefert die Formularnummer zurück
     * @return Eine 15-stellige Formularnummer
     */
    public String getFormularNummer() throws CommonException {
        if (!this.formularNummer.trim().isEmpty()) {
            return this.formularNummer;
        } else {
            throw new CommonException("Die Formularnummer ist leer");
        }
    }

    /**
     * Erstellt einen Prfoilstring, bestehend aus dem Empfänger (10-stellig), der Empfängerrolle (6-stellig), dem Absender (10-stellig), der Abesenderrolle (6-stellig), dem Dokumenttyp (3-stellig) und der Formularnummer (15-stellig).
     * Die Felder werden auch auf die erforderliche Länge erweitert.
     * @return Der generierte Profilstring
     */
    public String getProfilString() {
        StringBuilder sb = new StringBuilder();

        sb.append(formatAbbr(this.empfaenger, 10));
        sb.append(formatAbbr(this.empfaengerRoleType.toString(), 6));
        sb.append(formatAbbr(this.absender, 10));
        sb.append(formatAbbr(this.absenderRoleType.toString(), 6));
        sb.append(formatAbbr(this.dokumentTyp.toString(), 3));
        sb.append(formatAbbr(this.formularNummer, 15));

        return sb.toString();
    }

    /**
     * Füllt eine Zeichenkette mit Leerzeichen
     *
     * @param abbr Die Zeichenkette die auf die Länge erweitert werden soll
     * @param anzahlStelle Die Anzahl der Stellen AUF die Zeichenkette erweitert werden soll
     * @return Die Zeichenkette mit den aufgefüllten Leerzeichen
     */
    private String formatAbbr(String abbr, int anzahlStellen) {

        StringBuilder sb = new StringBuilder();

        sb.append(abbr);
        while (sb.length() < anzahlStellen) {
            sb.append(" ");
        }

        return sb.toString();
    }
}

