/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util.geo;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geonames.PostalCode;
import org.geonames.PostalCodeSearchCriteria;
import org.geonames.WebService;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.Waypoint;

/**
 * Utility-Klasse für Geo-Berechnungen
 * @author Marc Beck
 */
public class GeoUtil {

    /**
     * Gibt zu einer Liste von Addressn die Wegpunkte zurück
     * @param addresses
     * @return
     */
    public static Set<LabeledWaypoint> getLabeledWaypoints(List<Address> addresses) {
        Set<LabeledWaypoint> waypoints = new HashSet<LabeledWaypoint>();
        for (Address address : addresses) {
            if (address.getLatitude() != 0) {
                LabeledWaypoint labeledWaypoint = new LabeledWaypoint();
                labeledWaypoint.setPosition(new GeoPosition(address.getLatitude(), address.getLongitude()));
                labeledWaypoint.setLabel(address.getName1());
                labeledWaypoint.setC(findRolleColor(address.getRoleType()));
                waypoints.add(labeledWaypoint);
            }
        }
        return waypoints;
    }

    /**
     * Findet zu einem Ortsnamen und einer (optionalen) Postleitzahl den Geo-Code
     * @param name
     * @param plz 
     * @return
     */
    public static Waypoint findGeoCode(String name, String plz) {
        try {
            PostalCodeSearchCriteria searchCriteria = new PostalCodeSearchCriteria();
            if (name != null & !"".equals(name)) {
                searchCriteria.setPlaceName(name);
            }
            if (plz != null & !"".equals(plz)) {
                searchCriteria.setPostalCode(plz);
            }
            searchCriteria.setCountryCode("DE");
            searchCriteria.setMaxRows(1);
            List<PostalCode> searchResult = WebService.findNearbyPostalCodes(searchCriteria);
            if (!searchResult.isEmpty()) {
                return (new Waypoint(searchResult.get(0).getLatitude(), searchResult.get(0).getLongitude()));
            }
        } catch (Exception ex) {
            //ignorieren
        }
        return null;

    }

    /**
     * Liefert eine Farbe zu einer Rolle
     * @param rolle
     * @return
     */
    public static Color findRolleColor(RoleType rolle) {
        if (RoleType.Erzeuger.equals(rolle)) {
            return Color.RED;
        }
        if (RoleType.Beförderer.equals(rolle)) {
            return new Color(0, 102, 102);
        }
        if (RoleType.Entsorger.equals(rolle)) {
            return Color.BLUE;
        }
        return Color.GRAY;
    }
}
