/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util.geo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import org.jdesktop.swingx.JXMapViewer;
import org.jdesktop.swingx.mapviewer.Waypoint;
import org.jdesktop.swingx.mapviewer.WaypointRenderer;

/**
 *
 * @author Marc Beck
 */
public class LabeledWaypointRenderer implements WaypointRenderer {

    @Override
    public boolean paintWaypoint(Graphics2D gd, JXMapViewer jxmv, Waypoint wpnt) {
        LabeledWaypoint lw = (LabeledWaypoint) wpnt;

        gd.setPaint(lw.getC());
        Polygon triangle = new Polygon();
        triangle.addPoint(0, 0);
        triangle.addPoint(11, 11);
        triangle.addPoint(-11, 11);
        gd.fill(triangle);
        int width = (int) gd.getFontMetrics().getStringBounds(lw.getLabel(), gd).getWidth();
        gd.fillRoundRect(-width / 2 - 5, 10, width + 10, 20, 10, 10);

        gd.setPaint(Color.BLACK);
      //  gd.drawString(lw.getLabel(), -width / 2 - 1, 26 - 1);
      //  gd.drawString(lw.getLabel(), -width / 2 - 1, 26 - 1);
        gd.setPaint(Color.WHITE);
        gd.drawString(lw.getLabel(), -width / 2, 26);
        return false;

    }
}
