/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.util.jaxb;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

/**
 *
 * @author Marc Beck
 */
public class ZKSNamespacePrefixMapper extends NamespacePrefixMapper {

    @Override
    public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
        if ("http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri)) {
            return "xsi";
        }
        if ("uri:BMU_Waste_Interface/Message".equals(namespaceUri)) {
            return "msg";
        }
        if ("uri:BMU_Waste_Interface/ZKS".equals(namespaceUri)) {
            return "zks";
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(namespaceUri)) {
            return "ds";
        }
        if ("uri:BMU_Waste_Interface/Bibliothek".equals(namespaceUri)) {
            return "lib";
        }
        if ("uri:BMU_Waste_Interface/BGS".equals(namespaceUri)) {
            return "bgs";
        }
        if ("http://uri.etsi.org/01903/v1.3.2#".equals(namespaceUri)) {
            return "xad";
        }
        if ("uri:BMU_Waste_Interface/EN".equals(namespaceUri)) {
            return "en";
        }
        if ("uri:BMU_Waste_Interface/Reg".equals(namespaceUri)) {
            return "reg";
        }
        if ("uri:BMU_Waste_Interface/AGS".equals(namespaceUri)) {
            return "ags";
        }
        if ("uri:BMU_Waste_Interface/Ntz".equals(namespaceUri)) {
            return "ntz";
        }
        if ("uri:BMU_Waste_Interface/Kataloge".equals(namespaceUri)) {
            return "cat";
        }
        return suggestion;

    }
}
