/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MenuFrame.java
 *
 * Created on 11.01.2010, 14:50:13
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components;

import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.ErrorLogPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.webservice.WebServiceMonitorPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.SendMessagePanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.ReceiveMessagePanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.OSCIClientPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.MitteilungPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.MessageTrackerPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.ZKSConfigurationPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.CompanyPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressListPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel.TYPE;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Desktop;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import java.awt.Dimension;
import java.net.URL;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.JFrame;

/**
 *
 * @author Marc Beck
 */
public class MenuFrame extends javax.swing.JFrame {

    /** Creates new form MenuFrame */
    public MenuFrame() {
        initComponents();
        this.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent e) {
                closeWindow();
            }
        });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlTitle = new javax.swing.JPanel();
        lblTitle = new javax.swing.JLabel();
        pnlContent = new javax.swing.JPanel();
        lblCopyright = new javax.swing.JLabel();
        mbaMenuBar = new javax.swing.JMenuBar();
        mnuHome = new javax.swing.JMenu();
        mnuStammdaten = new javax.swing.JMenu();
        mniKontakte = new javax.swing.JMenuItem();
        mniUnternehmen = new javax.swing.JMenuItem();
        mniZKSKonfig = new javax.swing.JMenuItem();
        mnuNachrichten = new javax.swing.JMenu();
        mniSenden = new javax.swing.JMenuItem();
        mniAbholen = new javax.swing.JMenuItem();
        mniNachrichtenverfolgung = new javax.swing.JMenuItem();
        mnuZusatzfunktionen = new javax.swing.JMenu();
        mniOSCIPostfachBrowser = new javax.swing.JMenuItem();
        mniMitteilung = new javax.swing.JMenuItem();
        mniOSCIErrorLog = new javax.swing.JMenuItem();
        mnuWebService = new javax.swing.JMenu();
        mniWebservice = new javax.swing.JMenuItem();
        mnuInfo = new javax.swing.JMenu();
        mniHelp = new javax.swing.JMenuItem();
        mniInfo = new javax.swing.JMenuItem();
        mniKontaktUCB = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle(MessageBundle.getString("ApplicationName") + " " + MessageBundle.getString("Version"));
        setResizable(false);

        pnlTitle.setBackground(new java.awt.Color(1, 53, 103));
        pnlTitle.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        pnlTitle.setLayout(new java.awt.BorderLayout());

        lblTitle.setBackground(new java.awt.Color(1, 53, 103));
        lblTitle.setFont(new java.awt.Font("Tahoma", 1, 18));
        lblTitle.setForeground(new java.awt.Color(255, 255, 255));
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        lblTitle.setText(bundle.getString("bcsHome")); // NOI18N
        pnlTitle.add(lblTitle, java.awt.BorderLayout.PAGE_START);

        getContentPane().add(pnlTitle, java.awt.BorderLayout.NORTH);

        pnlContent.setLayout(new java.awt.CardLayout());
        pnlContent.add(infoPanel, "Info");
        pnlContent.add(uCBPanel, "Kontakt");
        pnlContent.add(zKSConfigurationPanel, "ZKSKonfig");
        pnlContent.add(CompanyPanel, "Unternehmen");
        pnlContent.add(addressListPanel, "Adressen");
        pnlContent.add(mitteilungPanel, "Mitteilung");
        this.dynamicPanel = new JPanel();
        this.dynamicPanel.setLayout(new BorderLayout());
        pnlContent.add(dynamicPanel, "Dynamic");
        getContentPane().add(pnlContent, java.awt.BorderLayout.CENTER);

        lblCopyright.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lblCopyright.setText(bundle.getString("CopyrightNotice")); // NOI18N
        lblCopyright.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        lblCopyright.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lblCopyrightMouseClicked(evt);
            }
        });
        getContentPane().add(lblCopyright, java.awt.BorderLayout.PAGE_END);

        mnuHome.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/navigation/Home16.gif"))); // NOI18N
        mnuHome.setFocusable(false);
        mnuHome.setRequestFocusEnabled(false);
        mnuHome.setRolloverEnabled(false);
        mnuHome.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                mnuHomeMouseClicked(evt);
            }
        });
        mbaMenuBar.add(mnuHome);

        mnuStammdaten.setText(bundle.getString("mnuStammdaten")); // NOI18N

        mniKontakte.setText(bundle.getString("mnuKontakte")); // NOI18N
        mniKontakte.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniKontakteActionPerformed(evt);
            }
        });
        mnuStammdaten.add(mniKontakte);

        mniUnternehmen.setText(bundle.getString("mnuUnternehmen")); // NOI18N
        mniUnternehmen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniUnternehmenActionPerformed(evt);
            }
        });
        mnuStammdaten.add(mniUnternehmen);

        mniZKSKonfig.setText(bundle.getString("mnuZKSKonfiguration")); // NOI18N
        mniZKSKonfig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniZKSKonfigActionPerformed(evt);
            }
        });
        mnuStammdaten.add(mniZKSKonfig);

        mbaMenuBar.add(mnuStammdaten);

        mnuNachrichten.setText(bundle.getString("mnuNachrichtendienst")); // NOI18N

        mniSenden.setText(bundle.getString("mnuNachrichtSenden")); // NOI18N
        mniSenden.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniSendenActionPerformed(evt);
            }
        });
        mnuNachrichten.add(mniSenden);

        mniAbholen.setText(bundle.getString("mnuNachrichtenAbrufen")); // NOI18N
        mniAbholen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniAbholenActionPerformed(evt);
            }
        });
        mnuNachrichten.add(mniAbholen);

        mniNachrichtenverfolgung.setText(bundle.getString("mnuNachrichtenverfolgung")); // NOI18N
        mniNachrichtenverfolgung.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniNachrichtenverfolgungActionPerformed(evt);
            }
        });
        mnuNachrichten.add(mniNachrichtenverfolgung);

        mnuZusatzfunktionen.setText(bundle.getString("mnuZusatzfunktionen")); // NOI18N

        mniOSCIPostfachBrowser.setText(bundle.getString("mnuOSCIPostfachBrowser")); // NOI18N
        mniOSCIPostfachBrowser.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniOSCIPostfachBrowserActionPerformed(evt);
            }
        });
        mnuZusatzfunktionen.add(mniOSCIPostfachBrowser);

        mniMitteilung.setText(bundle.getString("mnuMitteilung")); // NOI18N
        mniMitteilung.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniMitteilungActionPerformed(evt);
            }
        });
        mnuZusatzfunktionen.add(mniMitteilung);

        mniOSCIErrorLog.setText(bundle.getString("mnuOSCIFehler")); // NOI18N
        mniOSCIErrorLog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniOSCIErrorLogActionPerformed(evt);
            }
        });
        mnuZusatzfunktionen.add(mniOSCIErrorLog);

        mnuNachrichten.add(mnuZusatzfunktionen);

        mbaMenuBar.add(mnuNachrichten);

        mnuWebService.setText("Webservice");

        mniWebservice.setText(bundle.getString("mnuWebservice")); // NOI18N
        mniWebservice.setToolTipText("");
        mniWebservice.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniWebserviceActionPerformed(evt);
            }
        });
        mnuWebService.add(mniWebservice);

        mbaMenuBar.add(mnuWebService);

        mnuInfo.setText(bundle.getString("mnuHilfe")); // NOI18N

        mniHelp.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F1, 0));
        mniHelp.setText("Hilfe");
        mniHelp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniHelpActionPerformed(evt);
            }
        });
        mnuInfo.add(mniHelp);

        mniInfo.setText(bundle.getString("mnuInfo")); // NOI18N
        mniInfo.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniInfoActionPerformed(evt);
            }
        });
        mnuInfo.add(mniInfo);

        mniKontaktUCB.setText("Kontakt");
        mniKontaktUCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mniKontaktUCBActionPerformed(evt);
            }
        });
        mnuInfo.add(mniKontaktUCB);

        mbaMenuBar.add(mnuInfo);

        setJMenuBar(mbaMenuBar);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void mniUnternehmenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniUnternehmenActionPerformed
        // CompanyPanel anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Unternehmen");
        this.CompanyPanel.initView();
        lblTitle.setText(MessageBundle.getString("bcsUnternehmen"));
    }//GEN-LAST:event_mniUnternehmenActionPerformed

    private void mniKontakteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniKontakteActionPerformed
        // AdressenListPanel anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Adressen");
        lblTitle.setText(MessageBundle.getString("bcsKontakte"));
    }//GEN-LAST:event_mniKontakteActionPerformed

    private void mniZKSKonfigActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniZKSKonfigActionPerformed
        // ZKSConfigurationPanel anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "ZKSKonfig");
        this.zKSConfigurationPanel.initView();
        lblTitle.setText(MessageBundle.getString("bcsZKSKonfig"));
    }//GEN-LAST:event_mniZKSKonfigActionPerformed

    private void mniSendenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniSendenActionPerformed
        if (!checkAllowed(true, true, true)) {
            return;
        }
        // SendMessagePanel anzeigen
        this.dynamicPanel.invalidate();
        this.dynamicPanel.removeAll();
        this.dynamicPanel.add(new SendMessagePanel());
        this.dynamicPanel.validate();
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Dynamic");
        lblTitle.setText(MessageBundle.getString("bcsNachrichtSenden"));
    }//GEN-LAST:event_mniSendenActionPerformed

    private void mniAbholenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniAbholenActionPerformed
        if (!checkAllowed(true, false, true)) {
            return;
        }
        // ReceiveMessagePanel anzeigen
        this.dynamicPanel.invalidate();
        this.dynamicPanel.removeAll();
        this.dynamicPanel.add(new ReceiveMessagePanel());
        this.dynamicPanel.validate();
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Dynamic");
        lblTitle.setText(MessageBundle.getString("bcsNachrichtAbholen"));
    }//GEN-LAST:event_mniAbholenActionPerformed

    private void mniInfoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniInfoActionPerformed
        // Hilfe anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Info");
        lblTitle.setText(MessageBundle.getString("bcsInfo"));
    }//GEN-LAST:event_mniInfoActionPerformed

    private void mniNachrichtenverfolgungActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniNachrichtenverfolgungActionPerformed
        if (!checkAllowed(true, false, false)) {
            return;
        }
        Address address = null;
        if (company.getAddresses().size() > 1) {
            //Adresse auswählen
            AddressChooserPanel chooserPanel = new AddressChooserPanel(TYPE.ADDRESSES);
            JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
            dialog.setContentPane(chooserPanel);
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setTitle("Adresse auswählen");
            dialog.setModal(true);
            dialog.setVisible(true);
            address = chooserPanel.getAddress();
        } else {
            address = company.getAddresses().get(0);
        }
        if (address == null) {
            return;
        }
        // Nachrichtenverfolgung anzeigen
        this.dynamicPanel.invalidate();
        this.dynamicPanel.removeAll();
        this.dynamicPanel.add(new MessageTrackerPanel(address));
        this.dynamicPanel.validate();
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Dynamic");
        lblTitle.setText(MessageBundle.getString("bcsNachrichtenverfolgung"));
    }//GEN-LAST:event_mniNachrichtenverfolgungActionPerformed

    private void mniOSCIPostfachBrowserActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniOSCIPostfachBrowserActionPerformed
        if (!checkAllowed(true, false, true)) {
            return;
        }
        // Zeigt das OSCIClientPanel an
        this.dynamicPanel.invalidate();
        this.dynamicPanel.removeAll();
        this.dynamicPanel.add(new OSCIClientPanel());
        this.dynamicPanel.validate();
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Dynamic");
        lblTitle.setText(MessageBundle.getString("bcsOSCIPostfachBrowser"));
    }//GEN-LAST:event_mniOSCIPostfachBrowserActionPerformed

    private void mniOSCIErrorLogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniOSCIErrorLogActionPerformed
        // OSCI-Error-Log Dialog anzeigen
        ErrorLogPanel errorLogPanel = new ErrorLogPanel();
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(errorLogPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("osci-error.log");
        dialog.setModal(true);
        dialog.setVisible(true);
    }//GEN-LAST:event_mniOSCIErrorLogActionPerformed

    private void mniMitteilungActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniMitteilungActionPerformed
        // Mitteilung Panel anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Mitteilung");
        this.mitteilungPanel.initView();
        lblTitle.setText(MessageBundle.getString("bcsMitteilungVerfassen"));
    }//GEN-LAST:event_mniMitteilungActionPerformed

    private void mniWebserviceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniWebserviceActionPerformed
        // Webservice-Panel anzeigen
        WebServiceMonitorPanel panel = new WebServiceMonitorPanel();
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle(MessageBundle.getString("bcsWebservice"));
        dialog.setModal(true);
        dialog.setVisible(true);
    }//GEN-LAST:event_mniWebserviceActionPerformed

    private void lblCopyrightMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lblCopyrightMouseClicked
        //Bei Doppelklick auf ISS-Homepage browsen
        if (evt.getClickCount() == 2) {
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(new URI("http://www.iss.umwelt-campus.de/"));
                } catch (IOException ex) {
                    //nix machen, unkritisch
                } catch (URISyntaxException ex) {
                    //nix machen, unkritisch
                }
            }
        }
    }//GEN-LAST:event_lblCopyrightMouseClicked

    private void mniKontaktUCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniKontaktUCBActionPerformed
        // ContactUCBPanel anzeigen
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Kontakt");
        lblTitle.setText(MessageBundle.getString("bcsKontaktUCB"));
    }//GEN-LAST:event_mniKontaktUCBActionPerformed

    private void mnuHomeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mnuHomeMouseClicked
        //Home
        CardLayout cardLayout = (CardLayout) pnlContent.getLayout();
        cardLayout.show(pnlContent, "Info");
        lblTitle.setText(MessageBundle.getString("bcsHome"));
    }//GEN-LAST:event_mnuHomeMouseClicked

    private void mniHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mniHelpActionPerformed
        // Hilfe anzeigen
        JHelp helpViewer = null;
        try {
            ClassLoader cl = MenuFrame.class.getClassLoader();
            URL url = HelpSet.findHelpSet(cl, "jhelpset.hs");
            helpViewer = new JHelp(new HelpSet(cl, url));
            // Darzustellendes Kapitel festlegen, ID muss im XML existieren!
            helpViewer.setCurrentID("index");
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgHelpNotFound"), "Fehler", JOptionPane.ERROR_MESSAGE);
            return;
        }

        JFrame frame = new JFrame();
        frame.setTitle("Hilfe");
        frame.setIconImage(this.getIconImage());
        frame.getContentPane().add(helpViewer);
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.pack();
        //Doppelte Breite
        Dimension d = frame.getSize();
        d.width += d.width;
        frame.setSize(d);
        frame.setLocationRelativeTo(this);
        frame.setVisible(true);
    }//GEN-LAST:event_mniHelpActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel lblCopyright;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JMenuBar mbaMenuBar;
    private javax.swing.JMenuItem mniAbholen;
    private javax.swing.JMenuItem mniHelp;
    private javax.swing.JMenuItem mniInfo;
    private javax.swing.JMenuItem mniKontaktUCB;
    private javax.swing.JMenuItem mniKontakte;
    private javax.swing.JMenuItem mniMitteilung;
    private javax.swing.JMenuItem mniNachrichtenverfolgung;
    private javax.swing.JMenuItem mniOSCIErrorLog;
    private javax.swing.JMenuItem mniOSCIPostfachBrowser;
    private javax.swing.JMenuItem mniSenden;
    private javax.swing.JMenuItem mniUnternehmen;
    private javax.swing.JMenuItem mniWebservice;
    private javax.swing.JMenuItem mniZKSKonfig;
    private javax.swing.JMenu mnuHome;
    private javax.swing.JMenu mnuInfo;
    private javax.swing.JMenu mnuNachrichten;
    private javax.swing.JMenu mnuStammdaten;
    private javax.swing.JMenu mnuWebService;
    private javax.swing.JMenu mnuZusatzfunktionen;
    private javax.swing.JPanel pnlContent;
    private javax.swing.JPanel pnlTitle;
    // End of variables declaration//GEN-END:variables
    private Company company = CompanyFacade.getCompany();
    private JPanel dynamicPanel;
    private InfoPanel infoPanel = new InfoPanel();
    private ZKSConfigurationPanel zKSConfigurationPanel = new ZKSConfigurationPanel();
    private CompanyPanel CompanyPanel = new CompanyPanel();
    private AddressListPanel addressListPanel = new AddressListPanel();
    private MitteilungPanel mitteilungPanel = new MitteilungPanel();
    private ContactUCBPanel uCBPanel = new ContactUCBPanel();

    /**
     * Prüft, ob die Navigation erlaubt ist.
     * @param c Unternehmen
     * @param contact Kontakt
     * @param zks ZKS-Daten
     * @return
     */
    private boolean checkAllowed(boolean c, boolean contact, boolean zks) {

        if (c) {
            if (company.getAddresses().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Sie müssen zuerst eine Unternehmensadresse anlegen!", "Info", JOptionPane.INFORMATION_MESSAGE);
                return false;
            }
        }
        if (contact) {
            if (company.getContacts().isEmpty()) {
                JOptionPane.showMessageDialog(this, "Sie müssen zuerst einen Kontaktpartner anlegen!", "Info", JOptionPane.INFORMATION_MESSAGE);
                return false;
            }
        }
        if (zks) {
            if (company.getzKSConfig().getAddressIntermed() == null) {
                JOptionPane.showMessageDialog(this, "Sie müssen zuerst die Verbindungsdaten der ZKS einpflegen!", "Info", JOptionPane.INFORMATION_MESSAGE);
                return false;
            }
        }
        return true;
    }

    private void closeWindow() {
        int option = JOptionPane.showConfirmDialog(this, "Möchten Sie das Programm wirklich verlassen?", "Bestätigen", JOptionPane.YES_NO_OPTION);
        if (option == JOptionPane.YES_OPTION) {
            System.exit(1);
        }
    }
}
