/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * UnternehmenPanel.java
 *
 * Created on 24.06.2009, 10:28:35
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.AddressDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.CompanyDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.AddressTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.GeoUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.LabeledWaypoint;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.ZebraCellRendererDecorator;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableCellRenderer;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc Beck
 */
public class AddressListPanel extends javax.swing.JPanel {

    /** Creates new form UnternehmenPanel */
    public AddressListPanel() {
        initComponents();
        initView();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlAdressen = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblAdressen = new javax.swing.JTable();
        pnlFooter = new javax.swing.JPanel();
        btnNewAdresse = new javax.swing.JButton();
        btnEditAdresse = new javax.swing.JButton();
        btnDeleteAdresse = new javax.swing.JButton();
        btnShowOnMap = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        pnlAdressen.setBorder(javax.swing.BorderFactory.createTitledBorder("Adressen"));
        pnlAdressen.setLayout(new java.awt.BorderLayout());

        tblAdressen.setAutoCreateRowSorter(true);
        tblAdressen.setModel(new de.umweltcampus.uput.informatik.openeanvadapter.view.models.AddressTableModel(company.getContacts()));
        tblAdressen.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        tblAdressen.setDefaultRenderer(Object.class, new ZebraCellRendererDecorator(new DefaultTableCellRenderer()));
        jScrollPane1.setViewportView(tblAdressen);

        pnlAdressen.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(pnlAdressen, java.awt.BorderLayout.CENTER);

        pnlFooter.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        btnNewAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/New24.gif"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnNewAdresse.setToolTipText(bundle.getString("ttNeueAdresse")); // NOI18N
        btnNewAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewAdresseActionPerformed(evt);
            }
        });
        pnlFooter.add(btnNewAdresse);

        btnEditAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif"))); // NOI18N
        btnEditAdresse.setToolTipText(bundle.getString("ttAdresseBearbeiten")); // NOI18N
        btnEditAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnEditAdresseActionPerformed(evt);
            }
        });
        pnlFooter.add(btnEditAdresse);

        btnDeleteAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif"))); // NOI18N
        btnDeleteAdresse.setToolTipText(bundle.getString("ttAdresseLoeschen")); // NOI18N
        btnDeleteAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteAdresseActionPerformed(evt);
            }
        });
        pnlFooter.add(btnDeleteAdresse);

        btnShowOnMap.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/development/WebComponent24.gif"))); // NOI18N
        btnShowOnMap.setToolTipText(bundle.getString("ttShowOnMap")); // NOI18N
        btnShowOnMap.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowOnMapActionPerformed(evt);
            }
        });
        pnlFooter.add(btnShowOnMap);

        add(pnlFooter, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnNewAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewAdresseActionPerformed
        //Neue Address anlegen
        ContactAddressPanel adresseView = new ContactAddressPanel(null, company);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(adresseView);
        dialog.setTitle("Neue Adresse");
        dialog.setModal(true);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        initView();

}//GEN-LAST:event_btnNewAdresseActionPerformed

    private void btnEditAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnEditAdresseActionPerformed
        // Address bearbeiten
        int rowIndex = tblAdressen.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblAdressen.getRowSorter().convertRowIndexToModel(rowIndex);
            AddressTableModel adresseTableModel = (AddressTableModel) tblAdressen.getModel();
            Address address = adresseTableModel.getAddressAt(rowIndex);
            ContactAddressPanel adresseView = new ContactAddressPanel(address, company);
            JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
            dialog.setContentPane(adresseView);
            dialog.setTitle("Adresse bearbeiten");
            dialog.setModal(true);
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            initView();
        }

    }//GEN-LAST:event_btnEditAdresseActionPerformed

    private void btnDeleteAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteAdresseActionPerformed
        //Address löschen
        int rowIndex = tblAdressen.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblAdressen.getRowSorter().convertRowIndexToModel(rowIndex);
            int option = JOptionPane.showConfirmDialog(this, MessageBundle.getString("msgConfirmDelete"), MessageBundle.getString("msgConfirm"), JOptionPane.YES_NO_OPTION);
            if (option == JOptionPane.YES_OPTION) {
                AddressTableModel adresseTableModel = (AddressTableModel) tblAdressen.getModel();
                Address address = adresseTableModel.getAddressAt(rowIndex);
                company.getContacts().remove(address);
                CompanyDAO companyDAO = new CompanyDAO();
                companyDAO.edit(company);
                AddressDAO addressDAO = new AddressDAO();
                addressDAO.destroy(address);
                initView();
            }
        }
    }//GEN-LAST:event_btnDeleteAdresseActionPerformed

    private void btnShowOnMapActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowOnMapActionPerformed
        // Karte der Adressen anzeigen
        Set<LabeledWaypoint> waypoints = GeoUtil.getLabeledWaypoints(company.getContacts());
        if (!waypoints.isEmpty()) {
            JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
            dialog.setContentPane(new GeoMap(waypoints));
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setTitle("Karte");
            dialog.setModal(true);
            dialog.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgMapNotAvailable"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
        }

    }//GEN-LAST:event_btnShowOnMapActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnDeleteAdresse;
    private javax.swing.JButton btnEditAdresse;
    private javax.swing.JButton btnNewAdresse;
    private javax.swing.JButton btnShowOnMap;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel pnlAdressen;
    private javax.swing.JPanel pnlFooter;
    private javax.swing.JTable tblAdressen;
    // End of variables declaration//GEN-END:variables
    private Company company = CompanyFacade.getCompany();

    private void initView() {
        tblAdressen.setModel(new AddressTableModel(company.getContacts()));
    }
}
