/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AddressPanel.java
 *
 * Created on 21.06.2009, 14:08:46
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.AddressDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.CompanyDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Certificate;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.GenericUtils;
import de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldRegexValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import java.awt.Window;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;

/**
 *
 * @author Marc Beck
 */
public class AddressPanel extends javax.swing.JPanel {

    /** Creates new form AdresseView */
    public AddressPanel(Address address, Company company) {
        this.company = company;
        this.address = address;
        initComponents();
        initValidation();
        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlNorth = new javax.swing.JPanel();
        pnlAllgemein = new javax.swing.JPanel();
        lblBehoerdlicheNummer = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        lblPostleitzahl = new javax.swing.JLabel();
        lblOrt = new javax.swing.JLabel();
        lblRolle = new javax.swing.JLabel();
        lblProvidernummer = new javax.swing.JLabel();
        tfBehoerdlicheNummer = new javax.swing.JTextField();
        tfName = new javax.swing.JTextField();
        tfOrt = new javax.swing.JTextField();
        tfPostleitzahl = new javax.swing.JTextField();
        cbRolle = new javax.swing.JComboBox();
        tfProvidernummer = new javax.swing.JTextField();
        lblProviderRolle = new javax.swing.JLabel();
        cbProviderRolle = new javax.swing.JComboBox();
        tabZertifikate = new javax.swing.JTabbedPane();
        pnlZertifikat = new javax.swing.JPanel();
        lblStatus = new javax.swing.JLabel();
        chkZertifikat = new javax.swing.JCheckBox();
        btnShowZertifikat = new javax.swing.JButton();
        btnImportZertifikat = new javax.swing.JButton();
        btnSendZertifikat = new javax.swing.JButton();
        pnlSignaturZertifikat = new javax.swing.JPanel();
        lblSignaturZertifikatStatus = new javax.swing.JLabel();
        cbxSignaturzertifikat = new javax.swing.JCheckBox();
        btnImportSignaturzertifikat = new javax.swing.JButton();
        pfPassword = new javax.swing.JPasswordField();
        lblPassword = new javax.swing.JLabel();
        pnlSouth = new javax.swing.JPanel();
        pnlDefault = new javax.swing.JPanel();
        chkDefaultAdresse = new javax.swing.JCheckBox();
        pnlTimestamp = new javax.swing.JPanel();
        lblOSCITimestamp = new javax.swing.JLabel();
        tfOSCITimestamp = new javax.swing.JTextField();
        pnlFoot = new javax.swing.JPanel();
        btnSave = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        lblCreatedAt = new javax.swing.JLabel();
        lblLastChange = new javax.swing.JLabel();
        lblDateCreatedAt = new javax.swing.JLabel();
        lblDateLastChange = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        pnlNorth.setLayout(new java.awt.BorderLayout());

        pnlAllgemein.setBorder(javax.swing.BorderFactory.createTitledBorder("Allgemeine Daten"));

        lblBehoerdlicheNummer.setText("Behördliche Nummer:");

        lblName.setText("Name:");

        lblPostleitzahl.setText("Postleitzahl:");

        lblOrt.setText("Ort:");

        lblRolle.setText("Rolle:");

        lblProvidernummer.setText("Providernummer:");

        tfBehoerdlicheNummer.setDocument(new RestrictingDocument(9));

        tfName.setDocument(new RestrictingDocument(35));

        tfOrt.setDocument(new RestrictingDocument(35));

        tfPostleitzahl.setColumns(20);
        tfPostleitzahl.setDocument(new RestrictingDocument(9));

        cbRolle.setModel(new DefaultComboBoxModel(RoleType.values()));
        cbRolle.setRenderer(new de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.RoleTypeListCellRenderer(false));

        tfProvidernummer.setDocument(new RestrictingDocument(9));

        lblProviderRolle.setText("Providerrolle:");

        cbProviderRolle.setModel(new DefaultComboBoxModel(RoleType.values()));
        cbProviderRolle.setRenderer(new de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.RoleTypeListCellRenderer(false));

        javax.swing.GroupLayout pnlAllgemeinLayout = new javax.swing.GroupLayout(pnlAllgemein);
        pnlAllgemein.setLayout(pnlAllgemeinLayout);
        pnlAllgemeinLayout.setHorizontalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                        .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblBehoerdlicheNummer)
                            .addComponent(lblName)
                            .addComponent(lblOrt)
                            .addComponent(lblRolle)
                            .addComponent(lblProvidernummer)
                            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                                .addGap(4, 4, 4)
                                .addComponent(lblProviderRolle)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(cbProviderRolle, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(cbRolle, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(tfOrt)
                            .addComponent(tfName)
                            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                                .addGap(136, 136, 136)
                                .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(tfProvidernummer, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                        .addComponent(lblPostleitzahl)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(297, Short.MAX_VALUE))
        );
        pnlAllgemeinLayout.setVerticalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBehoerdlicheNummer)
                    .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblPostleitzahl)
                    .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblOrt)
                    .addComponent(tfOrt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblRolle)
                    .addComponent(cbRolle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblProvidernummer)
                    .addComponent(tfProvidernummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbProviderRolle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblProviderRolle)))
        );

        pnlNorth.add(pnlAllgemein, java.awt.BorderLayout.NORTH);

        pnlZertifikat.setBorder(javax.swing.BorderFactory.createTitledBorder("Öffentliches Adressierungszertifikat"));

        lblStatus.setText("Status:");

        chkZertifikat.setText("vorhanden");
        chkZertifikat.setEnabled(false);
        chkZertifikat.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                chkZertifikatStateChanged(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnShowZertifikat.setText(bundle.getString("View")); // NOI18N
        btnShowZertifikat.setToolTipText(bundle.getString("ttZertifikatAnzeigen")); // NOI18N
        btnShowZertifikat.setEnabled(false);
        btnShowZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowZertifikatActionPerformed(evt);
            }
        });

        btnImportZertifikat.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikat.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatActionPerformed(evt);
            }
        });

        btnSendZertifikat.setText(bundle.getString("TransmitCert")); // NOI18N
        btnSendZertifikat.setToolTipText(bundle.getString("ttZertifikatsübermittlung")); // NOI18N
        btnSendZertifikat.setEnabled(false);

        javax.swing.GroupLayout pnlZertifikatLayout = new javax.swing.GroupLayout(pnlZertifikat);
        pnlZertifikat.setLayout(pnlZertifikatLayout);
        pnlZertifikatLayout.setHorizontalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlZertifikatLayout.createSequentialGroup()
                        .addComponent(lblStatus)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(chkZertifikat))
                    .addGroup(pnlZertifikatLayout.createSequentialGroup()
                        .addComponent(btnShowZertifikat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnImportZertifikat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnSendZertifikat)))
                .addContainerGap(277, Short.MAX_VALUE))
        );
        pnlZertifikatLayout.setVerticalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblStatus)
                    .addComponent(chkZertifikat))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnShowZertifikat)
                    .addComponent(btnImportZertifikat)
                    .addComponent(btnSendZertifikat))
                .addContainerGap(27, Short.MAX_VALUE))
        );

        tabZertifikate.addTab("Öffentliches Zertifikat", pnlZertifikat);

        pnlSignaturZertifikat.setBorder(javax.swing.BorderFactory.createTitledBorder("Privates Signatur- und Verschlüsselungszertifikat"));

        lblSignaturZertifikatStatus.setText("Status:");

        cbxSignaturzertifikat.setText("vorhanden");
        cbxSignaturzertifikat.setEnabled(false);

        btnImportSignaturzertifikat.setText(bundle.getString("Import")); // NOI18N
        btnImportSignaturzertifikat.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportSignaturzertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportSignaturzertifikatActionPerformed(evt);
            }
        });

        lblPassword.setText("Passwort:");

        javax.swing.GroupLayout pnlSignaturZertifikatLayout = new javax.swing.GroupLayout(pnlSignaturZertifikat);
        pnlSignaturZertifikat.setLayout(pnlSignaturZertifikatLayout);
        pnlSignaturZertifikatLayout.setHorizontalGroup(
            pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSignaturZertifikatLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnImportSignaturzertifikat)
                    .addGroup(pnlSignaturZertifikatLayout.createSequentialGroup()
                        .addGroup(pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblSignaturZertifikatStatus)
                            .addComponent(lblPassword))
                        .addGap(57, 57, 57)
                        .addGroup(pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(pfPassword, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.PREFERRED_SIZE, 127, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(cbxSignaturzertifikat))))
                .addContainerGap(382, Short.MAX_VALUE))
        );
        pnlSignaturZertifikatLayout.setVerticalGroup(
            pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSignaturZertifikatLayout.createSequentialGroup()
                .addGroup(pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblSignaturZertifikatStatus)
                    .addComponent(cbxSignaturzertifikat))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlSignaturZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pfPassword, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblPassword))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnImportSignaturzertifikat))
        );

        tabZertifikate.addTab("Privates Zertifikat", pnlSignaturZertifikat);

        pnlNorth.add(tabZertifikate, java.awt.BorderLayout.SOUTH);

        add(pnlNorth, java.awt.BorderLayout.NORTH);

        pnlSouth.setLayout(new java.awt.BorderLayout());

        pnlDefault.setBorder(javax.swing.BorderFactory.createTitledBorder("Standard-Adresse"));
        pnlDefault.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        chkDefaultAdresse.setText("Diese Adresse als Standard-Adresse setzen");
        pnlDefault.add(chkDefaultAdresse);

        pnlSouth.add(pnlDefault, java.awt.BorderLayout.NORTH);

        pnlTimestamp.setBorder(javax.swing.BorderFactory.createTitledBorder("OSCI-Timestamp"));
        pnlTimestamp.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        lblOSCITimestamp.setText("Letztes Abrufdatum:");
        pnlTimestamp.add(lblOSCITimestamp);

        tfOSCITimestamp.setColumns(15);
        pnlTimestamp.add(tfOSCITimestamp);

        pnlSouth.add(pnlTimestamp, java.awt.BorderLayout.CENTER);

        pnlFoot.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        btnSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"))); // NOI18N
        btnSave.setText(bundle.getString("Apply")); // NOI18N
        btnSave.setToolTipText(bundle.getString("ttApplyChanges")); // NOI18N
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });

        btnCancel.setText(bundle.getString("Close")); // NOI18N
        btnCancel.setToolTipText(bundle.getString("ttClose")); // NOI18N
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        lblCreatedAt.setText("Angelegt am:");

        lblLastChange.setText("Zuletzt geändert am:");

        lblDateCreatedAt.setText(" ");

        lblDateLastChange.setText(" ");

        javax.swing.GroupLayout pnlFootLayout = new javax.swing.GroupLayout(pnlFoot);
        pnlFoot.setLayout(pnlFootLayout);
        pnlFootLayout.setHorizontalGroup(
            pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlFootLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblLastChange)
                    .addComponent(btnSave)
                    .addComponent(lblCreatedAt))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 433, Short.MAX_VALUE)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lblDateLastChange, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnCancel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlFootLayout.setVerticalGroup(
            pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlFootLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnSave)
                    .addComponent(btnCancel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblCreatedAt)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblLastChange)
                    .addComponent(lblDateLastChange))
                .addContainerGap())
        );

        pnlSouth.add(pnlFoot, java.awt.BorderLayout.SOUTH);

        add(pnlSouth, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        try {
            Window window = (Window) getTopLevelAncestor();
            window.dispose();
        } catch (Exception e) {
            //nix machen, Exception hier ist nicht kritisch
        }
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnImportZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatActionPerformed
        //Zertifikat importieren
        byte[] bs = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (bs != null) {
            if (address.getPublicCertificate() == null) {
                address.setPublicCertificate(new Certificate());
            }
            address.getPublicCertificate().setCertificate(bs);
            this.chkZertifikat.setSelected(true);
        }
    }//GEN-LAST:event_btnImportZertifikatActionPerformed

    private void btnShowZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowZertifikatActionPerformed
        //Zertifikat anzeigen
        if (this.address.getPublicCertificate() != null) {
            if (this.address.getPublicCertificate().getCertificate() != null) {
                FileUtil.viewFile(this.address.getPublicCertificate().getCertificate(), ".cer");
            }
        }
    }//GEN-LAST:event_btnShowZertifikatActionPerformed

    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
        //Validierungen anstossen
        boolean b = validatorChain.runValidation();
        if (!b) {
            validatorChain.viewValidationReport(this);
            return;
        }
        //Zertifikat prüfen
        if (!validatePassword()) {
            return;
        }
        // Adressen anlegen
        address.setRegisterNumber(tfBehoerdlicheNummer.getText());
        address.setName1(tfName.getText());
        address.setCity(tfOrt.getText());
        address.setPostalCode(tfPostleitzahl.getText());
        RoleType rolle = (RoleType) cbRolle.getSelectedItem();
        address.setRoleType(rolle);
        address.setProviderNumber(tfProvidernummer.getText());
        RoleType providerRolle = (RoleType) cbProviderRolle.getSelectedItem();
        address.setProviderRoleType(providerRolle);
        address.setOsciTimestamp(tfOSCITimestamp.getText());
        if (address.getPrivateCertificate() == null) {
            address.setPrivateCertificate(new Certificate());
        }
        address.getPrivateCertificate().setPassword(new String(pfPassword.getPassword()));
        AddressDAO adao = new AddressDAO();
        CompanyDAO unternehmenDAO = new CompanyDAO();
        if (address.getId() == null) {
            address = adao.create(address);
            company.getAddresses().add(address);
        } else {
            address = adao.edit(address);
        }
        if (this.chkDefaultAdresse.isSelected()) {
            company.setDefaultAddress(address);
        }
        unternehmenDAO.edit(company);
        //company = unternehmenDAO.findById(company.getId());
        initView();
        JOptionPane.showMessageDialog(this, MessageBundle.getString("msgAddressSaved"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
    }//GEN-LAST:event_btnSaveActionPerformed

    private void btnImportSignaturzertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportSignaturzertifikatActionPerformed
        //Zertifikat importieren
        byte[] bs = FileUtil.readFile(this, ".p12", "Zertifikat");
        if (bs != null) {
            if (address.getPrivateCertificate() == null) {
                address.setPrivateCertificate(new Certificate());
            }
            address.getPrivateCertificate().setCertificate(bs);
            this.cbxSignaturzertifikat.setSelected(true);
        }
    }//GEN-LAST:event_btnImportSignaturzertifikatActionPerformed

    private void chkZertifikatStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_chkZertifikatStateChanged
        // Den Anzeigen-Button freischalten
        if (chkZertifikat.isSelected()) {
            btnShowZertifikat.setEnabled(true);
        }
    }//GEN-LAST:event_chkZertifikatStateChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnImportSignaturzertifikat;
    private javax.swing.JButton btnImportZertifikat;
    private javax.swing.JButton btnSave;
    private javax.swing.JButton btnSendZertifikat;
    private javax.swing.JButton btnShowZertifikat;
    private javax.swing.JComboBox cbProviderRolle;
    private javax.swing.JComboBox cbRolle;
    private javax.swing.JCheckBox cbxSignaturzertifikat;
    private javax.swing.JCheckBox chkDefaultAdresse;
    private javax.swing.JCheckBox chkZertifikat;
    private javax.swing.JLabel lblBehoerdlicheNummer;
    private javax.swing.JLabel lblCreatedAt;
    private javax.swing.JLabel lblDateCreatedAt;
    private javax.swing.JLabel lblDateLastChange;
    private javax.swing.JLabel lblLastChange;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblOSCITimestamp;
    private javax.swing.JLabel lblOrt;
    private javax.swing.JLabel lblPassword;
    private javax.swing.JLabel lblPostleitzahl;
    private javax.swing.JLabel lblProviderRolle;
    private javax.swing.JLabel lblProvidernummer;
    private javax.swing.JLabel lblRolle;
    private javax.swing.JLabel lblSignaturZertifikatStatus;
    private javax.swing.JLabel lblStatus;
    private javax.swing.JPasswordField pfPassword;
    private javax.swing.JPanel pnlAllgemein;
    private javax.swing.JPanel pnlDefault;
    private javax.swing.JPanel pnlFoot;
    private javax.swing.JPanel pnlNorth;
    private javax.swing.JPanel pnlSignaturZertifikat;
    private javax.swing.JPanel pnlSouth;
    private javax.swing.JPanel pnlTimestamp;
    private javax.swing.JPanel pnlZertifikat;
    private javax.swing.JTabbedPane tabZertifikate;
    private javax.swing.JTextField tfBehoerdlicheNummer;
    private javax.swing.JTextField tfName;
    private javax.swing.JTextField tfOSCITimestamp;
    private javax.swing.JTextField tfOrt;
    private javax.swing.JTextField tfPostleitzahl;
    private javax.swing.JTextField tfProvidernummer;
    // End of variables declaration//GEN-END:variables
    private Address address;
    private Company company;
    private ValidatorChain validatorChain;

    /**
     * Initialisiert den Validator
     */
    private void initValidation() {
        this.validatorChain = new ValidatorChain();
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfBehoerdlicheNummer, "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfBehoerdlicheNummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfName, "Name"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfProvidernummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Providernummer"));
    }

    /**
     * Prüft das Zertifikat und das dazu gehörende Passwort
     * @return
     */
    private boolean validatePassword() {
        if (address.getPrivateCertificate() != null && pfPassword.getPassword() != null) {
            String password = new String(pfPassword.getPassword());
            boolean valid = GenericUtils.checkPassword(address.getPrivateCertificate().getCertificate(), password);
            if (!valid) {
                JOptionPane.showMessageDialog(this, MessageBundle.getString("msgWrongPasswordForCertificate"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            }
            return valid;
        } else {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgMissingCertificate"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
        }

        return false;
    }

    /**
     * Initialisiert die View-Komponenten
     */
    private void initView() {
        tfBehoerdlicheNummer.setText(address.getRegisterNumber());
        tfName.setText(address.getName1());
        tfPostleitzahl.setText(address.getPostalCode());
        tfOrt.setText(address.getCity());
        chkZertifikat.setSelected(address.getPublicCertificate() == null ? false : true);
        if (address.getRoleType() != null) {
            cbRolle.setSelectedItem(address.getRoleType());
        }
        tfProvidernummer.setText(address.getProviderNumber());
        if (address.getProviderRoleType() != null) {
            cbProviderRolle.setSelectedItem(address.getProviderRoleType());
        }

        if (address.getPrivateCertificate() != null) {
            cbxSignaturzertifikat.setSelected(address.getPrivateCertificate().getCertificate() == null ? false : true);
            pfPassword.setText(address.getPrivateCertificate().getPassword());
        }
        if (address.equals(company.getDefaultAddress())) {
            chkDefaultAdresse.setSelected(true);
        }
        //Wenn die Adresse neu ist, muss der OSCI-Timestamp initial gesetzt werden.
        if (address.getId() != null) {
            tfOSCITimestamp.setText(address.getOsciTimestamp());
        } else {
            tfOSCITimestamp.setText(GenericUtils.getISO8601Timestamp(new Date()));
        }

        if (address.getTimestamps() != null) {
            DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT);
            if (address.getTimestamps().getCreatedAt() != null) {
                lblDateCreatedAt.setText(df.format(address.getTimestamps().getCreatedAt()));
            }
            if (address.getTimestamps().getChangedAt() != null) {
                lblDateLastChange.setText(df.format(address.getTimestamps().getChangedAt()));
            }
        }
    }
}
