/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AdressantwortList.java
 *
 * Created on 12.01.2010, 16:07:57
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AdressantwortProcessor;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AdressantwortProcessor.AdressantwortBlock;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.AdressantwortBlockTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.ZebraCellRendererDecorator;
import java.awt.Window;
import java.util.List;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author Marc Beck
 */
public class AdressantwortList extends javax.swing.JPanel {

    /** Creates new form AdressantwortList */
    public AdressantwortList(List<AdressantwortProcessor.AdressantwortBlock> adressantwortBlocks) {
        this.adressantwortBlocks = adressantwortBlocks;
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        tblAdressantworten = new javax.swing.JTable();
        lblAdressantworten = new javax.swing.JLabel();
        pnlButtons = new javax.swing.JPanel();
        btnApply = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        tblAdressantworten.setAutoCreateRowSorter(true);
        tblAdressantworten.setModel(new AdressantwortBlockTableModel(adressantwortBlocks));
        tblAdressantworten.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        tblAdressantworten.setDefaultRenderer(Object.class, new ZebraCellRendererDecorator(new DefaultTableCellRenderer()));
        tblAdressantworten.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                tblAdressantwortenMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(tblAdressantworten);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);

        lblAdressantworten.setFont(new java.awt.Font("Tahoma", 0, 14));
        lblAdressantworten.setText("Liste der gefundenen Adressen:");
        add(lblAdressantworten, java.awt.BorderLayout.PAGE_START);

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnApply.setText(bundle.getString("Apply")); // NOI18N
        btnApply.setToolTipText(bundle.getString("ttApply")); // NOI18N
        btnApply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnApplyActionPerformed(evt);
            }
        });
        pnlButtons.add(btnApply);

        btnCancel.setText(bundle.getString("Cancel")); // NOI18N
        btnCancel.setToolTipText(bundle.getString("ttCancel")); // NOI18N
        pnlButtons.add(javax.swing.Box.createVerticalStrut(3));
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });
        pnlButtons.add(btnCancel);

        add(pnlButtons, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        try {
            Window window = (Window) getTopLevelAncestor();
            window.dispose();
        } catch (Exception e) {
            //nix machen, Exception hier ist nicht kritisch
        }
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnApplyActionPerformed
        // Adresse bearbeiten
        int rowIndex = tblAdressantworten.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblAdressantworten.getRowSorter().convertRowIndexToModel(rowIndex);
            AdressantwortBlockTableModel tableModel = (AdressantwortBlockTableModel) tblAdressantworten.getModel();
            this.adressantwortBlock = tableModel.getAdressantwortBlockAt(rowIndex);
            try {
                Window window = (Window) getTopLevelAncestor();
                window.dispose();
            } catch (Exception e) {
                //nix machen, Exception hier ist nicht kritisch
            }
        }
    }//GEN-LAST:event_btnApplyActionPerformed

    private void tblAdressantwortenMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_tblAdressantwortenMouseClicked
        // Bei Doppelklick, soll das gleiche geschehen wie bei Übernehmen-Button
        if (evt.getClickCount() == 2) {
            btnApplyActionPerformed(null);
        }
    }//GEN-LAST:event_tblAdressantwortenMouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnApply;
    private javax.swing.JButton btnCancel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblAdressantworten;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JTable tblAdressantworten;
    // End of variables declaration//GEN-END:variables
    private List<AdressantwortProcessor.AdressantwortBlock> adressantwortBlocks;
    private AdressantwortBlock adressantwortBlock;

    public AdressantwortBlock getAdressantwortBlock() {
        return adressantwortBlock;
    }
}
