/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CompanyPanel.java
 *
 * Created on 24.06.2009, 10:28:35
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.AddressDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.CompanyDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.AddressTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.ZebraCellRendererDecorator;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author Marc Beck
 */
public class CompanyPanel extends javax.swing.JPanel {

    /** Creates new form CompanyPanel */
    public CompanyPanel() {
        initComponents();
        initView();

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlUnternehmen = new javax.swing.JPanel();
        lblName = new javax.swing.JLabel();
        tfName = new javax.swing.JTextField();
        btnSave = new javax.swing.JButton();
        pnlAdressen = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblAdressen = new javax.swing.JTable();
        pnlButtons = new javax.swing.JPanel();
        btnNewAdresse = new javax.swing.JButton();
        btnEditAdresse = new javax.swing.JButton();
        btnDeleteAdresse = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        pnlUnternehmen.setBorder(javax.swing.BorderFactory.createTitledBorder("Unternehmen"));

        lblName.setText("Name:");

        btnSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnSave.setText(bundle.getString("Apply")); // NOI18N
        btnSave.setToolTipText(bundle.getString("ttApplyChanges")); // NOI18N
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlUnternehmenLayout = new javax.swing.GroupLayout(pnlUnternehmen);
        pnlUnternehmen.setLayout(pnlUnternehmenLayout);
        pnlUnternehmenLayout.setHorizontalGroup(
            pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblName)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tfName, javax.swing.GroupLayout.DEFAULT_SIZE, 220, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnSave))
        );
        pnlUnternehmenLayout.setVerticalGroup(
            pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnSave))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(pnlUnternehmen, java.awt.BorderLayout.NORTH);

        pnlAdressen.setBorder(javax.swing.BorderFactory.createTitledBorder("Adressen"));
        pnlAdressen.setLayout(new java.awt.BorderLayout());

        tblAdressen.setAutoCreateRowSorter(true);
        tblAdressen.setModel(new de.umweltcampus.uput.informatik.openeanvadapter.view.models.AddressTableModel(company.getAddresses()));
        tblAdressen.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        tblAdressen.setDefaultRenderer(Object.class, new ZebraCellRendererDecorator(new DefaultTableCellRenderer()));
        jScrollPane1.setViewportView(tblAdressen);

        pnlAdressen.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(pnlAdressen, java.awt.BorderLayout.CENTER);

        pnlButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        btnNewAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/New24.gif"))); // NOI18N
        btnNewAdresse.setToolTipText(bundle.getString("ttNeueAdresse")); // NOI18N
        btnNewAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewAdresseActionPerformed(evt);
            }
        });
        pnlButtons.add(btnNewAdresse);

        btnEditAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Edit24.gif"))); // NOI18N
        btnEditAdresse.setToolTipText(bundle.getString("ttAdresseBearbeiten")); // NOI18N
        btnEditAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnEditAdresseActionPerformed(evt);
            }
        });
        pnlButtons.add(btnEditAdresse);

        btnDeleteAdresse.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Delete24.gif"))); // NOI18N
        btnDeleteAdresse.setToolTipText(bundle.getString("ttAdresseLoeschen")); // NOI18N
        btnDeleteAdresse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDeleteAdresseActionPerformed(evt);
            }
        });
        pnlButtons.add(btnDeleteAdresse);

        add(pnlButtons, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
        company.setName(tfName.getText());
        CompanyDAO unternehmenDAO = new CompanyDAO();
        unternehmenDAO.edit(company);
        JOptionPane.showMessageDialog(this, MessageBundle.getString("msgCompanySaved"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);

}//GEN-LAST:event_btnSaveActionPerformed

    private void btnNewAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewAdresseActionPerformed
        //Neue Adresse anlegen
        AddressPanel adresseView = new AddressPanel(new Address(), company);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(adresseView);
        dialog.setTitle("Unternehmensadresse anlegen");
        dialog.setModal(true);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        initView();

}//GEN-LAST:event_btnNewAdresseActionPerformed

    private void btnEditAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnEditAdresseActionPerformed
        // Adresse bearbeiten
        int rowIndex = tblAdressen.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblAdressen.getRowSorter().convertRowIndexToModel(rowIndex);
            AddressTableModel adresseTableModel = (AddressTableModel) tblAdressen.getModel();
            Address address = adresseTableModel.getAddressAt(rowIndex);
            AddressPanel adresseView = new AddressPanel(address, company);
            JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
            dialog.setContentPane(adresseView);
            dialog.setTitle("Unternehmensadresse bearbeiten");
            dialog.setModal(true);
            dialog.pack();
            dialog.setLocationRelativeTo(this);
            dialog.setVisible(true);
            initView();
        }

    }//GEN-LAST:event_btnEditAdresseActionPerformed

    private void btnDeleteAdresseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDeleteAdresseActionPerformed
        //Adresse löschen
        int rowIndex = tblAdressen.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblAdressen.getRowSorter().convertRowIndexToModel(rowIndex);
            int option = JOptionPane.showConfirmDialog(this, "Wenn Sie die Unternehmensadresse löschen, werden auch alle dazugehörigen Nachrichten gelöscht.\nMöchten Sie die Adresse wirklich löschen?", "Bestätigen", JOptionPane.YES_NO_OPTION);
            if (option == JOptionPane.YES_OPTION) {
                AddressTableModel adresseTableModel = (AddressTableModel) tblAdressen.getModel();
                Address address = adresseTableModel.getAddressAt(rowIndex);
                if (address.equals(company.getDefaultAddress())) {
                    company.setDefaultAddress(null);
                }
                company.getAddresses().remove(address);
                CompanyDAO companyDAO = new CompanyDAO();
                companyDAO.edit(company);
                AddressDAO adao = new AddressDAO();
                adao.destroy(address);
                initView();
            }
        }
    }//GEN-LAST:event_btnDeleteAdresseActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnDeleteAdresse;
    private javax.swing.JButton btnEditAdresse;
    private javax.swing.JButton btnNewAdresse;
    private javax.swing.JButton btnSave;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblName;
    private javax.swing.JPanel pnlAdressen;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlUnternehmen;
    private javax.swing.JTable tblAdressen;
    private javax.swing.JTextField tfName;
    // End of variables declaration//GEN-END:variables
    private Company company = CompanyFacade.getCompany();

    public void initView() {
        tfName.setText(company.getName());
        tblAdressen.setModel(new AddressTableModel(company.getAddresses()));
    }
}
