/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * AdresseView.java
 *
 * Created on 21.06.2009, 14:08:46
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.MessageService;
import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageType;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.AddressDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.CompanyDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanforderungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.AdressanfrageDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AbstractZKSMessageProcessor;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AdressantwortProcessor;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.processors.AdressauskunftProcessor;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Certificate;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.MessageRequirementsValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.GeoUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldRegexValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import java.awt.Cursor;
import java.awt.Window;
import java.text.DateFormat;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.mapviewer.Waypoint;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc
 */
public class ContactAddressPanel extends javax.swing.JPanel {

    /** Creates new form AdresseView */
    public ContactAddressPanel(Address address, Company company) {
        if (address == null) {
            this.address = new Address();
        } else {
            this.address = address;
        }
        initComponents();
        initValidation();
        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlAllgemein = new javax.swing.JPanel();
        lblBehoerdlicheNummer = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        lblPostleitzahl = new javax.swing.JLabel();
        lblOrt = new javax.swing.JLabel();
        lblRolle = new javax.swing.JLabel();
        lblProvidernummer = new javax.swing.JLabel();
        tfBehoerdlicheNummer = new javax.swing.JTextField();
        tfName = new javax.swing.JTextField();
        tfOrt = new javax.swing.JTextField();
        cbRolle = new javax.swing.JComboBox();
        tfProvidernummer = new javax.swing.JTextField();
        btnAdressanfrage = new javax.swing.JButton();
        lblProviderRolle = new javax.swing.JLabel();
        cbProviderRolle = new javax.swing.JComboBox();
        tfPostleitzahl = new javax.swing.JTextField();
        pnlFoot = new javax.swing.JPanel();
        btnSave = new javax.swing.JButton();
        btnCancel = new javax.swing.JButton();
        lblCreatedAt = new javax.swing.JLabel();
        lblLastChange = new javax.swing.JLabel();
        lblDateCreatedAt = new javax.swing.JLabel();
        lblDateLastChange = new javax.swing.JLabel();
        pnlZertifikat = new javax.swing.JPanel();
        lblStatus = new javax.swing.JLabel();
        chkZertifikat = new javax.swing.JCheckBox();
        btnShowZertifikat = new javax.swing.JButton();
        btnImportZertifikat = new javax.swing.JButton();
        btnRetrieveZertifikat = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        pnlAllgemein.setBorder(javax.swing.BorderFactory.createTitledBorder("Allgemeine Daten"));

        lblBehoerdlicheNummer.setText("Behördliche Nummer:");

        lblName.setText("Name:");

        lblPostleitzahl.setText("PLZ:");

        lblOrt.setText("Ort:");

        lblRolle.setText("Rolle:");

        lblProvidernummer.setText("Providernummer:");

        tfBehoerdlicheNummer.setColumns(20);
        tfBehoerdlicheNummer.setDocument(new RestrictingDocument(9));

        tfName.setDocument(new RestrictingDocument(35));

        tfOrt.setDocument(new RestrictingDocument(35));

        cbRolle.setModel(new DefaultComboBoxModel(RoleType.values()));
        cbRolle.setRenderer(new de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.RoleTypeListCellRenderer(false));

        tfProvidernummer.setColumns(20);
        tfProvidernummer.setDocument(new RestrictingDocument(9));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnAdressanfrage.setText(bundle.getString("RequestAddress")); // NOI18N
        btnAdressanfrage.setToolTipText(bundle.getString("ttAdressanfrage")); // NOI18N
        btnAdressanfrage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAdressanfrageActionPerformed(evt);
            }
        });

        lblProviderRolle.setText("Providerrolle:");

        cbProviderRolle.setModel(new DefaultComboBoxModel(RoleType.values()));
        cbProviderRolle.setRenderer(new de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.RoleTypeListCellRenderer(false));

        tfPostleitzahl.setColumns(20);
        tfPostleitzahl.setDocument(new RestrictingDocument(9));

        javax.swing.GroupLayout pnlAllgemeinLayout = new javax.swing.GroupLayout(pnlAllgemein);
        pnlAllgemein.setLayout(pnlAllgemeinLayout);
        pnlAllgemeinLayout.setHorizontalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGap(4, 4, 4)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblProvidernummer)
                    .addComponent(lblProviderRolle)
                    .addComponent(lblRolle)
                    .addComponent(lblOrt)
                    .addComponent(lblPostleitzahl)
                    .addComponent(lblName)
                    .addComponent(lblBehoerdlicheNummer))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(cbProviderRolle, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, 219, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 99, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(cbRolle, 0, 219, Short.MAX_VALUE)
                    .addComponent(tfOrt, javax.swing.GroupLayout.DEFAULT_SIZE, 219, Short.MAX_VALUE)
                    .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, 101, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tfProvidernummer, javax.swing.GroupLayout.PREFERRED_SIZE, 99, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnAdressanfrage)
                .addContainerGap(281, Short.MAX_VALUE))
        );
        pnlAllgemeinLayout.setVerticalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnAdressanfrage)
                    .addComponent(lblBehoerdlicheNummer))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblName))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lblPostleitzahl)
                    .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lblOrt)
                    .addComponent(tfOrt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lblRolle)
                    .addComponent(cbRolle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(lblProvidernummer)
                    .addComponent(tfProvidernummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbProviderRolle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblProviderRolle)))
        );

        add(pnlAllgemein, java.awt.BorderLayout.NORTH);

        pnlFoot.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        btnSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"))); // NOI18N
        btnSave.setText(bundle.getString("Apply")); // NOI18N
        btnSave.setToolTipText(bundle.getString("ttApplyChanges")); // NOI18N
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });

        btnCancel.setText(bundle.getString("Close")); // NOI18N
        btnCancel.setToolTipText(bundle.getString("ttClose")); // NOI18N
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        lblCreatedAt.setText("Angelegt am:");

        lblLastChange.setText("Zuletzt geändert am:");

        lblDateCreatedAt.setText(" ");

        lblDateLastChange.setText(" ");

        javax.swing.GroupLayout pnlFootLayout = new javax.swing.GroupLayout(pnlFoot);
        pnlFoot.setLayout(pnlFootLayout);
        pnlFootLayout.setHorizontalGroup(
            pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlFootLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblLastChange)
                    .addComponent(btnSave)
                    .addComponent(lblCreatedAt))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 560, Short.MAX_VALUE)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lblDateLastChange, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnCancel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlFootLayout.setVerticalGroup(
            pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlFootLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnSave)
                    .addComponent(btnCancel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblCreatedAt)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlFootLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblLastChange)
                    .addComponent(lblDateLastChange))
                .addContainerGap())
        );

        add(pnlFoot, java.awt.BorderLayout.SOUTH);

        pnlZertifikat.setBorder(javax.swing.BorderFactory.createTitledBorder("Öffentliches Adressierungszertifikat"));

        lblStatus.setText("Status:");

        chkZertifikat.setText("vorhanden");
        chkZertifikat.setEnabled(false);
        chkZertifikat.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                chkZertifikatStateChanged(evt);
            }
        });

        btnShowZertifikat.setText(bundle.getString("View")); // NOI18N
        btnShowZertifikat.setToolTipText(bundle.getString("ttZertifikatAnzeigen")); // NOI18N
        btnShowZertifikat.setEnabled(false);
        btnShowZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowZertifikatActionPerformed(evt);
            }
        });

        btnImportZertifikat.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikat.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatActionPerformed(evt);
            }
        });

        btnRetrieveZertifikat.setText(bundle.getString("RequestCertificate")); // NOI18N
        btnRetrieveZertifikat.setToolTipText(bundle.getString("ttAdressanforderung")); // NOI18N
        btnRetrieveZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRetrieveZertifikatActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlZertifikatLayout = new javax.swing.GroupLayout(pnlZertifikat);
        pnlZertifikat.setLayout(pnlZertifikatLayout);
        pnlZertifikatLayout.setHorizontalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlZertifikatLayout.createSequentialGroup()
                        .addComponent(lblStatus)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(chkZertifikat))
                    .addGroup(pnlZertifikatLayout.createSequentialGroup()
                        .addComponent(btnShowZertifikat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnImportZertifikat)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnRetrieveZertifikat)))
                .addContainerGap(407, Short.MAX_VALUE))
        );
        pnlZertifikatLayout.setVerticalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblStatus)
                    .addComponent(chkZertifikat))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnShowZertifikat)
                    .addComponent(btnImportZertifikat)
                    .addComponent(btnRetrieveZertifikat))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(pnlZertifikat, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnAdressanfrageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAdressanfrageActionPerformed
        if (!MessageRequirementsValidator.validateCompany()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageCompany(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (!MessageRequirementsValidator.validateZKS()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageZKS(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (tfName.getText().length() < 2) {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgAdressanfrageNameRequired"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        //Cursor setzen
        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        MessageService service = new MessageService();
        Address sender = service.getDefaultAddress();
        //AdressdatenBean befüllen
        AdressanfrageDataContainer dataContainer = new AdressanfrageDataContainer(sender.getRegisterNumber(), sender.getRoleType().toString());
        if (!tfBehoerdlicheNummer.getText().equals("")) {
            dataContainer.setBehoerdlicheNummer(tfBehoerdlicheNummer.getText());
        }
        if (!tfName.getText().equals("")) {
            dataContainer.setFirmaName1(tfName.getText());
        }
        if (!tfOrt.getText().equals("")) {
            dataContainer.setFirmaOrt1(tfOrt.getText());
        }
        RoleType rolle = (RoleType) cbRolle.getSelectedItem();
        dataContainer.setAtbRolle(rolle.toString());
        if (!tfProvidernummer.getText().equals("")) {
            dataContainer.setProviderNummer(tfProvidernummer.getText());
            RoleType providerrolle = (RoleType) cbProviderRolle.getSelectedItem();
            dataContainer.setProviderATBRolle(providerrolle.toString());
        }
        //Adressanfrage losschicken
        AbstractZKSMessageProcessor processor = service.sendMessageViaWS(dataContainer, ZKSMessageType.ADRESSANFRAGE);
        //Cursor wieder ändern
        this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        //Ergebnis des Prozessors ausgeben
        processor.viewSwingResult(this);
        //Ggf. Daten übernehmen
        if (processor instanceof AdressantwortProcessor) {
            AdressantwortProcessor ap = (AdressantwortProcessor) processor;
            if (ap.getSelectedAdressantwort() != null) {
                AdressantwortProcessor.AdressantwortBlock adressantwortBlock = ap.getSelectedAdressantwort();
                applyAdressantwort(adressantwortBlock);
            }
        }

    }//GEN-LAST:event_btnAdressanfrageActionPerformed

    private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
        try {
            Window window = (Window) getTopLevelAncestor();
            window.dispose();
        } catch (Exception e) {
            //nix machen, Exception hier ist nicht kritisch
        }
    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnImportZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatActionPerformed
        //Zertifikat importieren
        byte[] bs = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (bs != null) {
            if (address.getPublicCertificate() == null) {
                address.setPublicCertificate(new Certificate());
            }
            address.getPublicCertificate().setCertificate(bs);
            this.chkZertifikat.setSelected(true);
        }
    }//GEN-LAST:event_btnImportZertifikatActionPerformed

    private void btnShowZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowZertifikatActionPerformed
        //Zertifikat anzeigen
        if (this.address.getPublicCertificate() != null) {
            if (this.address.getPublicCertificate().getCertificate() != null) {
                FileUtil.viewFile(this.address.getPublicCertificate().getCertificate(), ".cer");
            }
        }
    }//GEN-LAST:event_btnShowZertifikatActionPerformed

    private void btnRetrieveZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRetrieveZertifikatActionPerformed
        if (!MessageRequirementsValidator.validateCompany()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageCompany(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (!MessageRequirementsValidator.validateZKS()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageZKS(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        //Keine Anforderung schicken, wenn nicht mindestens die Behördliche Nummer eingegeben wurde
        if (tfBehoerdlicheNummer.getText().length() < 9) {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgAdressanforderungNummerRequired"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        //Cursor setzen
        this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
        //AdressdatenBean befüllen
        MessageService service = new MessageService();
        Address sender = service.getDefaultAddress();
        AdressanforderungDataContainer dataContainer = new AdressanforderungDataContainer(sender.getRegisterNumber(), sender.getRoleType().toString());
        if (!tfBehoerdlicheNummer.getText().equals("")) {
            dataContainer.setBehoerdlicheNummer(tfBehoerdlicheNummer.getText());
        }
        if (!tfName.getText().equals("")) {
            dataContainer.setFirmaName1(tfName.getText());
        }
        if (!tfOrt.getText().equals("")) {
            dataContainer.setFirmaOrt1(tfOrt.getText());
        }
        RoleType rolle = (RoleType) cbRolle.getSelectedItem();
        dataContainer.setAtbRolle(rolle.toString());
        if (!tfProvidernummer.getText().equals("")) {
            dataContainer.setProviderNummer(tfProvidernummer.getText());
            RoleType providerrolle = (RoleType) cbProviderRolle.getSelectedItem();
            dataContainer.setProviderATBRolle(providerrolle.toString());
        }
        //Adressanforderung abschicken
        AbstractZKSMessageProcessor processor = service.sendMessageViaWS(dataContainer, ZKSMessageType.ADRESSANFORDERUNG);
        //Daten übernehmen
        if (processor instanceof AdressauskunftProcessor) {
            AdressauskunftProcessor ap = (AdressauskunftProcessor) processor;
            if (ap.getCert() != null) {
                if (this.address.getPublicCertificate() == null) {
                    this.address.setPublicCertificate(new Certificate());
                }
                this.address.getPublicCertificate().setCertificate(ap.getCert());
                this.chkZertifikat.setSelected(true);
            }
        }
        //Cursor wieder ändern
        this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        processor.viewSwingResult(this);
    }//GEN-LAST:event_btnRetrieveZertifikatActionPerformed

    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
        //Validierungen anstossen
        boolean b = validatorChain.runValidation();
        if (!b) {
            validatorChain.viewValidationReport(this);
            return;
        }
        // Address anlegen
        address.setRegisterNumber(tfBehoerdlicheNummer.getText());
        address.setName1(tfName.getText());
        address.setCity(tfOrt.getText());
        address.setPostalCode(tfPostleitzahl.getText());
        address.setProviderNumber(tfProvidernummer.getText());
        RoleType rolle = (RoleType) cbRolle.getSelectedItem();
        address.setRoleType(rolle);
        RoleType providerRolle = (RoleType) cbProviderRolle.getSelectedItem();
        address.setProviderRoleType(providerRolle);
        //Geo-Position finden
        if (!"".equals(address.getPostalCode()) | !"".equals(address.getCity())) {
            Waypoint w = GeoUtil.findGeoCode(address.getCity(), address.getPostalCode());
            if (w != null) {
                if (w.getPosition() != null) {
                    address.setLatitude(w.getPosition().getLatitude());
                    address.setLongitude(w.getPosition().getLongitude());
                }
            }
        }
        //Sichern
        AddressDAO adao = new AddressDAO();
        CompanyDAO companyDAO = new CompanyDAO();
        if (address.getId() == null) {
            address = adao.create(address);
            company.getContacts().add(address);
        } else {
            address = adao.edit(address);
        }
        companyDAO.edit(company);
        JOptionPane.showMessageDialog(this, MessageBundle.getString("msgAdresseSaved"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
        initView();
    }//GEN-LAST:event_btnSaveActionPerformed

    private void chkZertifikatStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_chkZertifikatStateChanged
        // Den Anzeigen-Button freischalten
        if (chkZertifikat.isSelected()) {
            btnShowZertifikat.setEnabled(true);
        }
    }//GEN-LAST:event_chkZertifikatStateChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAdressanfrage;
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnImportZertifikat;
    private javax.swing.JButton btnRetrieveZertifikat;
    private javax.swing.JButton btnSave;
    private javax.swing.JButton btnShowZertifikat;
    private javax.swing.JComboBox cbProviderRolle;
    private javax.swing.JComboBox cbRolle;
    private javax.swing.JCheckBox chkZertifikat;
    private javax.swing.JLabel lblBehoerdlicheNummer;
    private javax.swing.JLabel lblCreatedAt;
    private javax.swing.JLabel lblDateCreatedAt;
    private javax.swing.JLabel lblDateLastChange;
    private javax.swing.JLabel lblLastChange;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblOrt;
    private javax.swing.JLabel lblPostleitzahl;
    private javax.swing.JLabel lblProviderRolle;
    private javax.swing.JLabel lblProvidernummer;
    private javax.swing.JLabel lblRolle;
    private javax.swing.JLabel lblStatus;
    private javax.swing.JPanel pnlAllgemein;
    private javax.swing.JPanel pnlFoot;
    private javax.swing.JPanel pnlZertifikat;
    private javax.swing.JTextField tfBehoerdlicheNummer;
    private javax.swing.JTextField tfName;
    private javax.swing.JTextField tfOrt;
    private javax.swing.JTextField tfPostleitzahl;
    private javax.swing.JTextField tfProvidernummer;
    // End of variables declaration//GEN-END:variables
    private Address address;
    private Company company = CompanyFacade.getCompany();
    private ValidatorChain validatorChain;

    /**
     * Initialisiert den Validator
     */
    private void initValidation() {
        this.validatorChain = new ValidatorChain();
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfBehoerdlicheNummer, "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfBehoerdlicheNummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfName, "Name"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfProvidernummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Providernummer"));
    }

    private void initView() {
        tfBehoerdlicheNummer.setText(address.getRegisterNumber());
        tfName.setText(address.getName1());
        tfOrt.setText(address.getCity());
        tfPostleitzahl.setText(address.getPostalCode());
        chkZertifikat.setSelected(address.getPublicCertificate() == null ? false : true);
        if (address.getRoleType() != null) {
            cbRolle.setSelectedItem(address.getRoleType());
        }
        tfProvidernummer.setText(address.getProviderNumber());
        if (address.getProviderRoleType() != null) {
            cbProviderRolle.setSelectedItem(address.getProviderRoleType());
        }
        if (address.getTimestamps() != null) {
            DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT);
            if (address.getTimestamps().getCreatedAt() != null) {
                lblDateCreatedAt.setText(df.format(address.getTimestamps().getCreatedAt()));
            }
            if (address.getTimestamps().getChangedAt() != null) {
                lblDateLastChange.setText(df.format(address.getTimestamps().getChangedAt()));
            }
        }
    }

    private void applyAdressantwort(AdressantwortProcessor.AdressantwortBlock adressantwortBlock) {
        this.tfBehoerdlicheNummer.setText(adressantwortBlock.getBehoerdlicheNummer());
        RoleType r = RoleType.getRolleByKurzBezeichnung(adressantwortBlock.getRolle());
        this.cbRolle.setSelectedItem(r);
        this.tfProvidernummer.setText(adressantwortBlock.getProviderNummer());
        if (!"".equals(adressantwortBlock.getProviderRolle())) {
            r = RoleType.getRolleByKurzBezeichnung(adressantwortBlock.getProviderRolle());
            this.cbProviderRolle.setSelectedItem(r);
        }
        this.tfName.setText(adressantwortBlock.getName());
    }
}
