/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * GeoMap.java
 *
 * Created on 20.01.2010, 14:29:37
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.GeoUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.LabeledWaypoint;
import de.umweltcampus.uput.informatik.openeanvadapter.util.geo.LabeledWaypointRenderer;
import java.awt.Window;
import java.util.Set;
import org.jdesktop.swingx.mapviewer.GeoPosition;
import org.jdesktop.swingx.mapviewer.WaypointPainter;

/**
 *
 * @author Marc Beck
 */
public class GeoMap extends javax.swing.JPanel {

    /** Creates new form GeoMap */
    public GeoMap(Set<LabeledWaypoint> waypoints) {
        this.waypoints = waypoints;
        
        initComponents();

        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        xmkGeoMap = new org.jdesktop.swingx.JXMapKit();
        pnlButtons = new javax.swing.JPanel();
        btnClose = new javax.swing.JButton();
        pnlLegende = new javax.swing.JPanel();
        pnlErzeuger = new javax.swing.JPanel();
        lblErzeuger = new javax.swing.JLabel();
        pnlBefoerderer = new javax.swing.JPanel();
        lblBefoerderer = new javax.swing.JLabel();
        pnlEntsorger = new javax.swing.JPanel();
        lblEntsorger = new javax.swing.JLabel();
        pnlSonstige = new javax.swing.JPanel();
        lblSonstige = new javax.swing.JLabel();

        xmkGeoMap.setDefaultProvider(org.jdesktop.swingx.JXMapKit.DefaultProviders.OpenStreetMaps);
        xmkGeoMap.setMiniMapVisible(false);
        xmkGeoMap.setZoom(12);

        pnlButtons.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnClose.setText(bundle.getString("Close")); // NOI18N
        btnClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCloseActionPerformed(evt);
            }
        });
        pnlButtons.add(btnClose);

        pnlLegende.setBorder(javax.swing.BorderFactory.createTitledBorder("Legende"));
        pnlLegende.setLayout(new java.awt.GridLayout(8, 1));

        pnlErzeuger.setBackground(GeoUtil.findRolleColor(RoleType.Erzeuger));
        pnlErzeuger.setLayout(new java.awt.BorderLayout());

        lblErzeuger.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblErzeuger.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblErzeuger.setText(" Erzeuger ");
        lblErzeuger.setForeground(new java.awt.Color(255, 255, 255));
        pnlErzeuger.add(lblErzeuger, java.awt.BorderLayout.CENTER);

        pnlLegende.add(pnlErzeuger);

        pnlBefoerderer.setBackground(GeoUtil.findRolleColor(RoleType.Beförderer));
        pnlBefoerderer.setLayout(new java.awt.BorderLayout());

        lblBefoerderer.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblBefoerderer.setForeground(new java.awt.Color(255, 255, 255));
        lblBefoerderer.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblBefoerderer.setText(" Beförderer ");
        pnlBefoerderer.add(lblBefoerderer, java.awt.BorderLayout.CENTER);

        pnlLegende.add(pnlBefoerderer);

        pnlEntsorger.setBackground(GeoUtil.findRolleColor(RoleType.Entsorger));
        pnlEntsorger.setLayout(new java.awt.BorderLayout());

        lblEntsorger.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblEntsorger.setForeground(new java.awt.Color(255, 255, 255));
        lblEntsorger.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblEntsorger.setText(" Entsorger ");
        pnlEntsorger.add(lblEntsorger, java.awt.BorderLayout.CENTER);

        pnlLegende.add(pnlEntsorger);

        pnlSonstige.setBackground(GeoUtil.findRolleColor(RoleType.Sonstiger));
        pnlSonstige.setLayout(new java.awt.BorderLayout());

        lblSonstige.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblSonstige.setForeground(new java.awt.Color(255, 255, 255));
        lblSonstige.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        lblSonstige.setText(" Sonstige ");
        pnlSonstige.add(lblSonstige, java.awt.BorderLayout.CENTER);

        pnlLegende.add(pnlSonstige);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(xmkGeoMap, javax.swing.GroupLayout.PREFERRED_SIZE, 761, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addComponent(pnlLegende, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addComponent(pnlButtons, javax.swing.GroupLayout.PREFERRED_SIZE, 860, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(xmkGeoMap, javax.swing.GroupLayout.PREFERRED_SIZE, 572, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pnlLegende, javax.swing.GroupLayout.PREFERRED_SIZE, 572, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addComponent(pnlButtons, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCloseActionPerformed
        // Schließt den Dialog
        try {
            Window window = (Window) getTopLevelAncestor();
            window.dispose();
        } catch (Exception e) {
            //nix machen, Exception hier ist nicht kritisch
        }
    }//GEN-LAST:event_btnCloseActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnClose;
    private javax.swing.JLabel lblBefoerderer;
    private javax.swing.JLabel lblEntsorger;
    private javax.swing.JLabel lblErzeuger;
    private javax.swing.JLabel lblSonstige;
    private javax.swing.JPanel pnlBefoerderer;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlEntsorger;
    private javax.swing.JPanel pnlErzeuger;
    private javax.swing.JPanel pnlLegende;
    private javax.swing.JPanel pnlSonstige;
    private org.jdesktop.swingx.JXMapKit xmkGeoMap;
    // End of variables declaration//GEN-END:variables
    private Set<LabeledWaypoint> waypoints;

    private void initView() {
        WaypointPainter painter = new WaypointPainter();
        painter.setWaypoints(waypoints);
        xmkGeoMap.setAddressLocation(new GeoPosition(49.616666, 7.2));
        painter.setRenderer(new LabeledWaypointRenderer());
        xmkGeoMap.getMainMap().setOverlayPainter(painter);
    }
}
