/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ZKSParameterPanel.java
 *
 * Created on 17.06.2009, 15:02:36
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.ParameterService;
import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.ZKSConfigurationDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Certificate;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.MessageRequirementsValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldRegexValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import java.text.DateFormat;
import javax.swing.JOptionPane;

/**
 *
 * @author Marc Beck
 */
public class ZKSConfigurationPanel extends javax.swing.JPanel {

    /** Creates new form ZKSParameterPanel */
    public ZKSConfigurationPanel() {
        Company company = CompanyFacade.getCompany();
        this.zKSConfiguration = company.getzKSConfig();
        initComponents();
        initView();
        initValidation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlKonfig = new javax.swing.JPanel();
        lblAdresseIntermediaer = new javax.swing.JLabel();
        tfAdresseIntermediaer = new javax.swing.JTextField();
        lblZertifikatIntermediaer = new javax.swing.JLabel();
        cbxZertifikatIntermediaer = new javax.swing.JCheckBox();
        btnViewZertifikatIntermediaer = new javax.swing.JButton();
        btnImportZertifikatIntermediaer = new javax.swing.JButton();
        lblZertifikatServicemodul = new javax.swing.JLabel();
        cbxZertifikatServiceModul = new javax.swing.JCheckBox();
        btnViewZertifikatServicemodul = new javax.swing.JButton();
        btnImportZertifikatServicemodul = new javax.swing.JButton();
        lblServiceModulNummer = new javax.swing.JLabel();
        tfBehoerdlicheNummer = new javax.swing.JTextField();
        pnlSonstiges = new javax.swing.JPanel();
        lblAnsprechpartner = new javax.swing.JLabel();
        tfAnsprechpartner = new javax.swing.JTextField();
        lblServiceLink = new javax.swing.JLabel();
        tfServiceLink = new javax.swing.JTextField();
        pnlFooter = new javax.swing.JPanel();
        pnlButtons = new javax.swing.JPanel();
        btnSave = new javax.swing.JButton();
        btnZKSParamererabfrage = new javax.swing.JButton();
        pnlTimestamps = new javax.swing.JPanel();
        lblDateCreatedAt = new javax.swing.JLabel();
        lblCreatedAt = new javax.swing.JLabel();
        lblLastChange = new javax.swing.JLabel();
        lblDateLastChange = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        pnlKonfig.setBorder(javax.swing.BorderFactory.createTitledBorder("ZKS Konfiguration"));

        lblAdresseIntermediaer.setText("Adresse des Intermediärs:");

        tfAdresseIntermediaer.setText("http://vps.zks-mtu.kdo.de/osci-manager-entry/externalentry");

        lblZertifikatIntermediaer.setText("Öffentliches Zertifikat des Intermediärs:");

        cbxZertifikatIntermediaer.setText("vorhanden");
        cbxZertifikatIntermediaer.setEnabled(false);
        cbxZertifikatIntermediaer.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                cbxZertifikatIntermediaerStateChanged(evt);
            }
        });

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnViewZertifikatIntermediaer.setText(bundle.getString("View")); // NOI18N
        btnViewZertifikatIntermediaer.setToolTipText(bundle.getString("ttZertifikatAnzeigen")); // NOI18N
        btnViewZertifikatIntermediaer.setEnabled(false);
        btnViewZertifikatIntermediaer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewZertifikatIntermediaerActionPerformed(evt);
            }
        });

        btnImportZertifikatIntermediaer.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikatIntermediaer.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikatIntermediaer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatIntermediaerActionPerformed(evt);
            }
        });

        lblZertifikatServicemodul.setText("Öffentliches Zertifikat des Servicemoduls:");

        cbxZertifikatServiceModul.setText("vorhanden");
        cbxZertifikatServiceModul.setEnabled(false);
        cbxZertifikatServiceModul.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                cbxZertifikatServiceModulStateChanged(evt);
            }
        });

        btnViewZertifikatServicemodul.setText(bundle.getString("View")); // NOI18N
        btnViewZertifikatServicemodul.setToolTipText(bundle.getString("ttZertifikatAnzeigen")); // NOI18N
        btnViewZertifikatServicemodul.setEnabled(false);
        btnViewZertifikatServicemodul.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewZertifikatServicemodulActionPerformed(evt);
            }
        });

        btnImportZertifikatServicemodul.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikatServicemodul.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikatServicemodul.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatServicemodulActionPerformed(evt);
            }
        });

        lblServiceModulNummer.setText("Behördliche Nummer des Servicemoduls:");

        tfBehoerdlicheNummer.setDocument(new RestrictingDocument(9));

        javax.swing.GroupLayout pnlKonfigLayout = new javax.swing.GroupLayout(pnlKonfig);
        pnlKonfig.setLayout(pnlKonfigLayout);
        pnlKonfigLayout.setHorizontalGroup(
            pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlKonfigLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tfAdresseIntermediaer, javax.swing.GroupLayout.DEFAULT_SIZE, 704, Short.MAX_VALUE)
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(pnlKonfigLayout.createSequentialGroup()
                                .addComponent(cbxZertifikatIntermediaer)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btnViewZertifikatIntermediaer)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btnImportZertifikatIntermediaer))
                            .addComponent(lblAdresseIntermediaer)
                            .addComponent(lblZertifikatIntermediaer))
                        .addContainerGap(453, Short.MAX_VALUE))
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addComponent(lblServiceModulNummer)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblZertifikatServicemodul)
                            .addGroup(pnlKonfigLayout.createSequentialGroup()
                                .addComponent(cbxZertifikatServiceModul)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btnViewZertifikatServicemodul)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btnImportZertifikatServicemodul)))
                        .addContainerGap(453, Short.MAX_VALUE))))
        );
        pnlKonfigLayout.setVerticalGroup(
            pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlKonfigLayout.createSequentialGroup()
                .addComponent(lblAdresseIntermediaer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tfAdresseIntermediaer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblZertifikatIntermediaer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbxZertifikatIntermediaer)
                    .addComponent(btnViewZertifikatIntermediaer)
                    .addComponent(btnImportZertifikatIntermediaer))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblServiceModulNummer)
                    .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblZertifikatServicemodul)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbxZertifikatServiceModul)
                    .addComponent(btnViewZertifikatServicemodul)
                    .addComponent(btnImportZertifikatServicemodul))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(pnlKonfig, java.awt.BorderLayout.NORTH);

        pnlSonstiges.setBorder(javax.swing.BorderFactory.createTitledBorder("Sonstiges"));

        lblAnsprechpartner.setText("Ansprechpartner:");

        lblServiceLink.setText("Service-Link:");

        javax.swing.GroupLayout pnlSonstigesLayout = new javax.swing.GroupLayout(pnlSonstiges);
        pnlSonstiges.setLayout(pnlSonstigesLayout);
        pnlSonstigesLayout.setHorizontalGroup(
            pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSonstigesLayout.createSequentialGroup()
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lblServiceLink, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lblAnsprechpartner, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(tfAnsprechpartner, javax.swing.GroupLayout.DEFAULT_SIZE, 590, Short.MAX_VALUE)
                    .addComponent(tfServiceLink, javax.swing.GroupLayout.DEFAULT_SIZE, 590, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlSonstigesLayout.setVerticalGroup(
            pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSonstigesLayout.createSequentialGroup()
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblAnsprechpartner, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tfAnsprechpartner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tfServiceLink, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblServiceLink, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        add(pnlSonstiges, java.awt.BorderLayout.CENTER);

        pnlFooter.setLayout(new java.awt.BorderLayout());

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));

        btnSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/Save16.gif"))); // NOI18N
        btnSave.setText(bundle.getString("Apply")); // NOI18N
        btnSave.setToolTipText(bundle.getString("ttApplyChanges")); // NOI18N
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });
        pnlButtons.add(btnSave);

        btnZKSParamererabfrage.setText(bundle.getString("RequestZKSParameters")); // NOI18N
        btnZKSParamererabfrage.setToolTipText(bundle.getString("ttZKSParameter")); // NOI18N
        btnZKSParamererabfrage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnZKSParamererabfrageActionPerformed(evt);
            }
        });
        pnlButtons.add(javax.swing.Box.createVerticalStrut(3));
        pnlButtons.add(btnZKSParamererabfrage);

        pnlFooter.add(pnlButtons, java.awt.BorderLayout.CENTER);

        lblDateCreatedAt.setText(" ");

        lblCreatedAt.setText("Angelegt am:");

        lblLastChange.setText("Zuletzt geändert am:");

        lblDateLastChange.setText(" ");

        javax.swing.GroupLayout pnlTimestampsLayout = new javax.swing.GroupLayout(pnlTimestamps);
        pnlTimestamps.setLayout(pnlTimestampsLayout);
        pnlTimestampsLayout.setHorizontalGroup(
            pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlTimestampsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblLastChange)
                    .addComponent(lblCreatedAt))
                .addGap(530, 530, 530)
                .addGroup(pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lblDateLastChange, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.DEFAULT_SIZE, 79, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlTimestampsLayout.setVerticalGroup(
            pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlTimestampsLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblCreatedAt)
                    .addComponent(lblDateCreatedAt, javax.swing.GroupLayout.PREFERRED_SIZE, 14, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(pnlTimestampsLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblLastChange)
                    .addComponent(lblDateLastChange))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlFooter.add(pnlTimestamps, java.awt.BorderLayout.SOUTH);

        add(pnlFooter, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnViewZertifikatIntermediaerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewZertifikatIntermediaerActionPerformed
        if (this.zKSConfiguration.getCertificateIntermed() != null) {
            if (this.zKSConfiguration.getCertificateIntermed().getCertificate() != null) {
                FileUtil.viewFile(this.zKSConfiguration.getCertificateIntermed().getCertificate(), ".cer");
            }
        }
    }//GEN-LAST:event_btnViewZertifikatIntermediaerActionPerformed

    private void btnViewZertifikatServicemodulActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewZertifikatServicemodulActionPerformed
        if (this.zKSConfiguration.getCertificateServicemodul() != null) {
            if (this.zKSConfiguration.getCertificateServicemodul().getCertificate() != null) {
                FileUtil.viewFile(this.zKSConfiguration.getCertificateServicemodul().getCertificate(), ".cer");
            }
        }
    }//GEN-LAST:event_btnViewZertifikatServicemodulActionPerformed

    private void btnImportZertifikatIntermediaerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatIntermediaerActionPerformed
        //Zertifikat importieren
        byte[] bs = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (bs != null) {
            if (this.zKSConfiguration.getCertificateIntermed() == null) {
                this.zKSConfiguration.setCertificateIntermed(new Certificate());
            }
            this.zKSConfiguration.getCertificateIntermed().setCertificate(bs);
            this.cbxZertifikatIntermediaer.setSelected(true);
        }
    }//GEN-LAST:event_btnImportZertifikatIntermediaerActionPerformed

    private void btnImportZertifikatServicemodulActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatServicemodulActionPerformed
        //Zertifikat importieren
        byte[] bs = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (bs != null) {
            if (this.zKSConfiguration.getCertificateServicemodul() == null) {
                this.zKSConfiguration.setCertificateServicemodul(new Certificate());
            }
            this.zKSConfiguration.getCertificateServicemodul().setCertificate(bs);
            this.cbxZertifikatServiceModul.setSelected(true);
        }
    }//GEN-LAST:event_btnImportZertifikatServicemodulActionPerformed

    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
        //Validierungen anstossen
        boolean b = validatorChain.runValidation();
        if (!b) {
            validatorChain.viewValidationReport(this);
            return;
        }
        //Werte übertragen:
        this.zKSConfiguration.setAddressIntermed(tfAdresseIntermediaer.getText());
        this.zKSConfiguration.setRegisterNumber(tfBehoerdlicheNummer.getText());
        this.zKSConfiguration.setContactPerson(tfAnsprechpartner.getText());
        this.zKSConfiguration.setServiceLink(tfServiceLink.getText());
        //Speichern:
        ZKSConfigurationDAO zkscdao = new ZKSConfigurationDAO();
        this.zKSConfiguration = zkscdao.edit(zKSConfiguration);
        JOptionPane.showMessageDialog(this, MessageBundle.getString("msgZKSConifgurationSaved"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
        initView();
    }//GEN-LAST:event_btnSaveActionPerformed

    private void btnZKSParamererabfrageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnZKSParamererabfrageActionPerformed
        if (!MessageRequirementsValidator.validateCompany()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageCompany(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (!MessageRequirementsValidator.validateZKS()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageZKS(), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
            return;
        }
        (new ParameterService()).sendZKSParametersRequest();
    }//GEN-LAST:event_btnZKSParamererabfrageActionPerformed

    private void cbxZertifikatIntermediaerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_cbxZertifikatIntermediaerStateChanged
        // Den Anzeigen-Button freischalten
        if (cbxZertifikatIntermediaer.isSelected()) {
            btnViewZertifikatIntermediaer.setEnabled(true);
        }
    }//GEN-LAST:event_cbxZertifikatIntermediaerStateChanged

    private void cbxZertifikatServiceModulStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_cbxZertifikatServiceModulStateChanged
        // Den Anzeigen-Button freischalten
        if (cbxZertifikatServiceModul.isSelected()) {
            btnViewZertifikatServicemodul.setEnabled(true);
        }
    }//GEN-LAST:event_cbxZertifikatServiceModulStateChanged
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnImportZertifikatIntermediaer;
    private javax.swing.JButton btnImportZertifikatServicemodul;
    private javax.swing.JButton btnSave;
    private javax.swing.JButton btnViewZertifikatIntermediaer;
    private javax.swing.JButton btnViewZertifikatServicemodul;
    private javax.swing.JButton btnZKSParamererabfrage;
    private javax.swing.JCheckBox cbxZertifikatIntermediaer;
    private javax.swing.JCheckBox cbxZertifikatServiceModul;
    private javax.swing.JLabel lblAdresseIntermediaer;
    private javax.swing.JLabel lblAnsprechpartner;
    private javax.swing.JLabel lblCreatedAt;
    private javax.swing.JLabel lblDateCreatedAt;
    private javax.swing.JLabel lblDateLastChange;
    private javax.swing.JLabel lblLastChange;
    private javax.swing.JLabel lblServiceLink;
    private javax.swing.JLabel lblServiceModulNummer;
    private javax.swing.JLabel lblZertifikatIntermediaer;
    private javax.swing.JLabel lblZertifikatServicemodul;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlFooter;
    private javax.swing.JPanel pnlKonfig;
    private javax.swing.JPanel pnlSonstiges;
    private javax.swing.JPanel pnlTimestamps;
    private javax.swing.JTextField tfAdresseIntermediaer;
    private javax.swing.JTextField tfAnsprechpartner;
    private javax.swing.JTextField tfBehoerdlicheNummer;
    private javax.swing.JTextField tfServiceLink;
    // End of variables declaration//GEN-END:variables
    private ZKSConfiguration zKSConfiguration;
    private ValidatorChain validatorChain;

    /**
     * Initialisiert den Validator
     */
    private void initValidation() {
        this.validatorChain = new ValidatorChain();
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfAdresseIntermediaer, "Intermediär Adresse"));
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfBehoerdlicheNummer, "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfBehoerdlicheNummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Behördliche Nummer"));

    }

    /**
     * Initialisiert die View-Komponenten mit den Daten aus
     * der ZKS Konfiguration
     */
    public void initView() {
        this.tfAdresseIntermediaer.setText(zKSConfiguration.getAddressIntermed());
        this.tfBehoerdlicheNummer.setText(zKSConfiguration.getRegisterNumber());
        this.tfAnsprechpartner.setText(zKSConfiguration.getContactPerson());
        this.tfServiceLink.setText(zKSConfiguration.getServiceLink());
        if (zKSConfiguration.getCertificateIntermed() != null) {
            if (zKSConfiguration.getCertificateIntermed().getCertificate() != null) {
                cbxZertifikatIntermediaer.setSelected(true);
            }
        }
        if (zKSConfiguration.getCertificateServicemodul() != null) {
            if (zKSConfiguration.getCertificateServicemodul().getCertificate() != null) {
                cbxZertifikatServiceModul.setSelected(true);
            }
        }
        if (zKSConfiguration.getTimestamps() != null) {
            DateFormat df = DateFormat.getDateTimeInstance(DateFormat.MEDIUM, DateFormat.SHORT);
            if (zKSConfiguration.getTimestamps().getCreatedAt() != null) {
                lblDateCreatedAt.setText(df.format(zKSConfiguration.getTimestamps().getCreatedAt()));
            }
            if (zKSConfiguration.getTimestamps().getChangedAt() != null) {
                lblDateLastChange.setText(df.format(zKSConfiguration.getTimestamps().getChangedAt()));
            }
        }
    }
}
