/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ErrorLogPanel.java
 *
 * Created on 22.07.2009, 16:17:01
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.OSCIErrorLog;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import java.util.List;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 *
 * @author Marc Beck
 */
public class ErrorLogPanel extends javax.swing.JPanel {

    /** Creates new form ErrorLogPanel */
    public ErrorLogPanel() {
        initComponents();
        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        txaErrorLog = new javax.swing.JTextArea();

        setLayout(new java.awt.BorderLayout());

        txaErrorLog.setColumns(100);
        txaErrorLog.setEditable(false);
        txaErrorLog.setRows(30);
        txaErrorLog.setMinimumSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(txaErrorLog);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea txaErrorLog;
    // End of variables declaration//GEN-END:variables
    private Company company = CompanyFacade.getCompany();

    private void initView() {
        List<OSCIErrorLog> list = company.getoSCIErrorLogs();
        if (list.isEmpty()) {
            txaErrorLog.setText(MessageBundle.getString("msgNoOSCIErrors"));
        } else {
            StringBuilder builder = new StringBuilder();
            builder.append("Datum | Code | Meldung | Profil\n");
            for (int i = 0; i < list.size(); i++) {
                OSCIErrorLog errorLog = list.get(i);
                builder.append(errorLog.getListedSince());
                builder.append(" | ");
                builder.append(errorLog.getErrorCode());
                builder.append(" | ");
                builder.append(errorLog.getMessage());
                builder.append(" | ");
                builder.append(errorLog.getProfile());
                builder.append("\n");
            }
            txaErrorLog.setText(builder.toString());
        }

    }
}
