/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MessageListPanel.java
 *
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.MessageDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Message;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.GenericUtils;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.DateTimeCellRenderer;
import de.umweltcampus.uput.informatik.openeanvadapter.view.listeners.DetailPopupListener;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.ReceivedMessagesTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.SentMessagesTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.MessageTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.ZebraCellRendererDecorator;
import java.awt.Rectangle;
import java.util.Date;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPopupMenu;
import javax.swing.RowFilter;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableRowSorter;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;

/**
 * NachrichtenPanel
 * Kann gesendete oder empfangene Nachrichten enthalten.
 * @author Marc Beck
 */
public class MessageListPanel extends javax.swing.JPanel {

    public enum TYP {

        GESENDETE_NACHRICHTEN,
        EMPFANGENE_NACHRICHTEN;
    }

    /** Creates new form GesendeteNachrichtenPanel */
    public MessageListPanel(Address address, TYP typ) {
        MessageDAO mdao = new MessageDAO();
        List<Message> messages;
        if (typ == TYP.GESENDETE_NACHRICHTEN) {
            messages = mdao.findByNamedQuery("Message.findBySender", address);
            this.messageTableModel = new SentMessagesTableModel(messages);
        } else {
            messages = mdao.findByNamedQuery("Message.findByReceiver", address);
            this.messageTableModel = new ReceivedMessagesTableModel(messages);
        }
        initComponents();
        DetailPopupListener dpl = new DetailPopupListener(tblNachrichten);
        tblNachrichten.addMouseListener(dpl);
        tblNachrichten.addKeyListener(dpl);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlFilter = new javax.swing.JPanel();
        lblMessageTypeFilter = new javax.swing.JLabel();
        cmbMessageTypeFilter = new javax.swing.JComboBox();
        tbtFilter = new javax.swing.JToggleButton();
        pnlEmpfangeneNachrichten = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblNachrichten = new javax.swing.JTable();
        tblNachrichten.setDefaultRenderer(Object.class, new ZebraCellRendererDecorator(new DefaultTableCellRenderer()));
        tblNachrichten.setDefaultRenderer(Date.class, new ZebraCellRendererDecorator(new DateTimeCellRenderer()));
        pnlContentFooter = new javax.swing.JPanel();
        btnView = new javax.swing.JButton();
        btnSaveAs = new javax.swing.JButton();
        btnOSCIKommunikation = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        pnlFilter.setBorder(javax.swing.BorderFactory.createTitledBorder("Filter"));
        pnlFilter.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.LEFT));

        lblMessageTypeFilter.setText("Nachrichtentyp:");
        pnlFilter.add(lblMessageTypeFilter);

        cmbMessageTypeFilter.setModel(new DefaultComboBoxModel(GenericUtils.getDokTypNames().toArray()));
        cmbMessageTypeFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbMessageTypeFilterActionPerformed(evt);
            }
        });
        pnlFilter.add(cmbMessageTypeFilter);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        tbtFilter.setText(bundle.getString("FilterTable")); // NOI18N
        tbtFilter.setToolTipText(bundle.getString("ttFilter")); // NOI18N
        tbtFilter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                tbtFilterActionPerformed(evt);
            }
        });
        pnlFilter.add(tbtFilter);

        add(pnlFilter, java.awt.BorderLayout.NORTH);

        pnlEmpfangeneNachrichten.setBorder(javax.swing.BorderFactory.createTitledBorder("BMU-Nachrichten"));
        pnlEmpfangeneNachrichten.setLayout(new java.awt.BorderLayout());

        tblNachrichten.setAutoCreateRowSorter(true);
        tblNachrichten.setModel(messageTableModel);
        tblNachrichten.setToolTipText(bundle.getString("ttRechtsklickOSCINachrichten")); // NOI18N
        tblNachrichten.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        tblNachrichten.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                checkButtons();
            }
        });
        jScrollPane1.setViewportView(tblNachrichten);

        pnlEmpfangeneNachrichten.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        add(pnlEmpfangeneNachrichten, java.awt.BorderLayout.CENTER);

        pnlContentFooter.setLayout(new javax.swing.BoxLayout(pnlContentFooter, javax.swing.BoxLayout.LINE_AXIS));

        btnView.setText(bundle.getString("View")); // NOI18N
        btnView.setToolTipText(bundle.getString("ttViewMessage")); // NOI18N
        btnView.setEnabled(false);
        btnView.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewActionPerformed(evt);
            }
        });
        pnlContentFooter.add(btnView);

        btnSaveAs.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"))); // NOI18N
        btnSaveAs.setText(bundle.getString("SaveAsFile")); // NOI18N
        btnSaveAs.setToolTipText(bundle.getString("ttSaveMessage")); // NOI18N
        btnSaveAs.setEnabled(false);
        btnSaveAs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveAsActionPerformed(evt);
            }
        });
        pnlContentFooter.add(btnSaveAs);

        btnOSCIKommunikation.setText(bundle.getString("OSCIKommunikation")); // NOI18N
        btnOSCIKommunikation.setToolTipText(bundle.getString("ttOSCIKommunikation")); // NOI18N
        btnOSCIKommunikation.setEnabled(false);
        btnOSCIKommunikation.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnOSCIKommunikationActionPerformed(evt);
            }
        });
        pnlContentFooter.add(btnOSCIKommunikation);

        add(pnlContentFooter, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnViewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewActionPerformed
        // Zeigt die selektierte Nachricht mit System-Mitteln an.
        int rowIndex = tblNachrichten.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblNachrichten.getRowSorter().convertRowIndexToModel(rowIndex);
            MessageTableModel tm = (MessageTableModel) tblNachrichten.getModel();
            Message nachricht = tm.getMessageAt(rowIndex);
            FileUtil.viewFile(nachricht.getMessage(), ".xml");
        }
    }//GEN-LAST:event_btnViewActionPerformed

    private void btnSaveAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveAsActionPerformed
        // Speichert die selektierte Nachricht als Datei
        int rowIndex = tblNachrichten.getSelectedRow();
        if (rowIndex != -1) {
            rowIndex = tblNachrichten.getRowSorter().convertRowIndexToModel(rowIndex);
            MessageTableModel tm = (MessageTableModel) tblNachrichten.getModel();
            Message nachricht = tm.getMessageAt(rowIndex);
            FileUtil.saveAs(this, nachricht.getMessage(), "Nachricht.xml");
        }
    }//GEN-LAST:event_btnSaveAsActionPerformed

    private void tbtFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_tbtFilterActionPerformed

        if (tbtFilter.isSelected()) {
            // Filter Table
            if (cmbMessageTypeFilter.getSelectedItem() != null) {
                String filterMessageType = cmbMessageTypeFilter.getSelectedItem().toString();
                TableRowSorter sorter = (TableRowSorter) tblNachrichten.getRowSorter();
                sorter.setRowFilter(RowFilter.regexFilter(filterMessageType));
                tbtFilter.setText(MessageBundle.getString("ResetFilter"));
                tbtFilter.setToolTipText(MessageBundle.getString("ttResetFilter"));
            }
        } else {
            // reset Filter
            TableRowSorter sorter = (TableRowSorter) tblNachrichten.getRowSorter();
            sorter.setRowFilter(null);
            tbtFilter.setText(MessageBundle.getString("FilterTable"));
            tbtFilter.setToolTipText(MessageBundle.getString("ttFilter"));
        }
    }//GEN-LAST:event_tbtFilterActionPerformed

    private void cmbMessageTypeFilterActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbMessageTypeFilterActionPerformed
        if (tbtFilter.isSelected()) {
            String filterMessageType = cmbMessageTypeFilter.getSelectedItem().toString();
            TableRowSorter sorter = (TableRowSorter) tblNachrichten.getRowSorter();
            sorter.setRowFilter(RowFilter.regexFilter(filterMessageType));
        }
    }//GEN-LAST:event_cmbMessageTypeFilterActionPerformed

    private void btnOSCIKommunikationActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOSCIKommunikationActionPerformed
        // OSCI-Kommunikation-PopUp anzeigen
        int index = tblNachrichten.getSelectedRow();
        if (index != -1) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            MessageTableModel entm = (MessageTableModel) tblNachrichten.getModel();
            Message nachricht = entm.getMessageAt(index);
            jPopupMenu.add(new OSCIMessageListPanel(nachricht.getOsciMessages()));
            Rectangle r = tblNachrichten.getCellRect(tblNachrichten.getRowSorter().convertRowIndexToView(index), tblNachrichten.getSelectedColumn(), false);
            jPopupMenu.show(tblNachrichten, r.x, r.y);
        }
}//GEN-LAST:event_btnOSCIKommunikationActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnOSCIKommunikation;
    private javax.swing.JButton btnSaveAs;
    private javax.swing.JButton btnView;
    private javax.swing.JComboBox cmbMessageTypeFilter;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblMessageTypeFilter;
    private javax.swing.JPanel pnlContentFooter;
    private javax.swing.JPanel pnlEmpfangeneNachrichten;
    private javax.swing.JPanel pnlFilter;
    private javax.swing.JTable tblNachrichten;
    private javax.swing.JToggleButton tbtFilter;
    // End of variables declaration//GEN-END:variables
    private MessageTableModel messageTableModel;

    private void checkButtons() {
        if (this.tblNachrichten.getSelectedRow() == -1) {
            this.btnView.setEnabled(false);
            this.btnSaveAs.setEnabled(false);
            this.btnOSCIKommunikation.setEnabled(false);
        } else {
            this.btnView.setEnabled(true);
            this.btnSaveAs.setEnabled(true);
            this.btnOSCIKommunikation.setEnabled(true);
        }
    }
}
