/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

/**
 *
 * @author Marc Beck
 */
public class MessageTrackerPanel extends JPanel {

    public MessageTrackerPanel(Address address) {
        JTabbedPane tbpNachrichten = new JTabbedPane();

        setLayout(new java.awt.BorderLayout());

        tbpNachrichten.addTab(MessageBundle.getString("lblReceivedMessages"), new MessageListPanel(address, MessageListPanel.TYP.EMPFANGENE_NACHRICHTEN));
        tbpNachrichten.addTab(MessageBundle.getString("lblSentMessages"), new MessageListPanel(address, MessageListPanel.TYP.GESENDETE_NACHRICHTEN));
        add(tbpNachrichten, java.awt.BorderLayout.CENTER);
    }
}
