/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MitteilungPanel.java
 *
 * Created on 07.12.2009, 13:43:03
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.containers.MitteilungDataContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.documents.generators.MitteilungGenerator;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import javax.swing.JOptionPane;

/**
 *
 * @author Marc Beck
 */
public class MitteilungPanel extends javax.swing.JPanel {

    /** Creates new form MitteilungPanel */
    public MitteilungPanel() {
        initComponents();
        initValidation();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblZweck = new javax.swing.JLabel();
        cbxZweck = new javax.swing.JComboBox();
        lblThema = new javax.swing.JLabel();
        lblText = new javax.swing.JLabel();
        lblBezug = new javax.swing.JLabel();
        tfBezug = new javax.swing.JTextField();
        tfThema = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        txaText = new javax.swing.JTextArea();
        btnSave = new javax.swing.JButton();

        lblZweck.setText("Zweck:\n");

        cbxZweck.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Memo", "Sonstige" }));

        lblThema.setText("Thema:");

        lblText.setText("Text:");

        lblBezug.setText("Bezug:");

        tfBezug.setDocument(new RestrictingDocument(255));
        tfBezug.setPreferredSize(new java.awt.Dimension(90, 20));

        tfThema.setDocument(new RestrictingDocument(255));

        txaText.setColumns(20);
        txaText.setDocument(new RestrictingDocument(1023));
        txaText.setRows(5);
        jScrollPane1.setViewportView(txaText);

        btnSave.setIcon(new javax.swing.ImageIcon(getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnSave.setText(bundle.getString("SaveAsFile")); // NOI18N
        btnSave.setToolTipText(bundle.getString("ttMitteilungSpeichern")); // NOI18N
        btnSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSaveActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblBezug)
                            .addComponent(lblZweck)
                            .addComponent(lblThema)
                            .addComponent(lblText))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 337, Short.MAX_VALUE)
                            .addComponent(tfThema, javax.swing.GroupLayout.DEFAULT_SIZE, 337, Short.MAX_VALUE)
                            .addComponent(tfBezug, javax.swing.GroupLayout.DEFAULT_SIZE, 337, Short.MAX_VALUE)
                            .addComponent(cbxZweck, 0, 337, Short.MAX_VALUE)))
                    .addComponent(btnSave))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBezug)
                    .addComponent(tfBezug, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblZweck)
                    .addComponent(cbxZweck, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblThema)
                    .addComponent(tfThema, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblText)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 173, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnSave)
                .addContainerGap(19, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void btnSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSaveActionPerformed
        //Nur ausführen, falls Validierung klar geht
        if (validatorChain.runValidation()) {
            //Mitteilung generieren
            MitteilungDataContainer container = new MitteilungDataContainer(null, null);
            container.setZweck((String) cbxZweck.getSelectedItem());
            container.setBezug(tfBezug.getText());
            container.setThema(tfThema.getText());
            container.setText(txaText.getText());
            MitteilungGenerator mitteilungGenerator = new MitteilungGenerator();
            byte[] bs = mitteilungGenerator.generateMessage(container);
            //Speichern
            if (FileUtil.saveAs(this, bs, "Mitteilung.xml")) {
                // Dialog anzeigen und Felder leeren
                JOptionPane.showMessageDialog(this, MessageBundle.getString("msgMessageSaved"), MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
                initView();
            }
        }

    }//GEN-LAST:event_btnSaveActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnSave;
    private javax.swing.JComboBox cbxZweck;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblBezug;
    private javax.swing.JLabel lblText;
    private javax.swing.JLabel lblThema;
    private javax.swing.JLabel lblZweck;
    private javax.swing.JTextField tfBezug;
    private javax.swing.JTextField tfThema;
    private javax.swing.JTextArea txaText;
    // End of variables declaration//GEN-END:variables
    private ValidatorChain validatorChain;

    /**
     * Initialisiert den Validator
     */
    private void initValidation() {
        this.validatorChain = new ValidatorChain();
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfThema, "Thema"));
    }

    public void initView() {
        cbxZweck.setSelectedIndex(0);
        tfBezug.setText("");
        tfThema.setText("");
        txaText.setText("");
    }
}
