/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * OSCIClientPanel.java
 *
 * Created on 17.11.2009, 12:54:52
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.MessageHeaderContainer;
import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.OSCIProxy;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel.TYPE;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.DateTimeCellRenderer;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.MessageHeaderContainerTableModel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.ZebraCellRendererDecorator;
import java.util.Date;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author Marc Beck
 */
public class OSCIClientPanel extends javax.swing.JPanel {

    /** Creates new form OSCIClientPanel */
    public OSCIClientPanel() {
        Company company = CompanyFacade.getCompany();
        this.address = company.getDefaultAddress();
        initComponents();
        initView();
        this.proxy = new OSCIProxy();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlHeader = new javax.swing.JPanel();
        btnLoadMessages = new javax.swing.JButton();
        pnlEmpfaenger = new javax.swing.JPanel();
        lblBehNummer = new javax.swing.JLabel();
        tfBehNummer = new javax.swing.JTextField();
        lblName = new javax.swing.JLabel();
        tfName = new javax.swing.JTextField();
        btnChoose = new javax.swing.JButton();
        pnlMessageList = new javax.swing.JPanel();
        lblHeader = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        tblOSCIMessages = new javax.swing.JTable();
        btnGetMessage = new javax.swing.JButton();
        lblStatus = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        pnlHeader.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0), 2));
        pnlHeader.setLayout(new java.awt.BorderLayout());

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnLoadMessages.setText(bundle.getString("GetList")); // NOI18N
        btnLoadMessages.setToolTipText(bundle.getString("ttLadeOSCIListe")); // NOI18N
        btnLoadMessages.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLoadMessagesActionPerformed(evt);
            }
        });
        pnlHeader.add(btnLoadMessages, java.awt.BorderLayout.CENTER);

        pnlEmpfaenger.setBorder(javax.swing.BorderFactory.createTitledBorder("Postfach"));

        lblBehNummer.setText("Behördliche Nummer:");

        tfBehNummer.setColumns(20);
        tfBehNummer.setEditable(false);

        lblName.setText("Name:");

        tfName.setColumns(20);
        tfName.setEditable(false);

        btnChoose.setText(bundle.getString("Choose")); // NOI18N
        btnChoose.setToolTipText(bundle.getString("ttChoosePostfach")); // NOI18N
        btnChoose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChooseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlEmpfaengerLayout = new javax.swing.GroupLayout(pnlEmpfaenger);
        pnlEmpfaenger.setLayout(pnlEmpfaengerLayout);
        pnlEmpfaengerLayout.setHorizontalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnChoose, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblBehNummer)
                            .addComponent(lblName))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfName, javax.swing.GroupLayout.DEFAULT_SIZE, 255, Short.MAX_VALUE)
                            .addComponent(tfBehNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 255, Short.MAX_VALUE))))
                .addContainerGap())
        );
        pnlEmpfaengerLayout.setVerticalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBehNummer)
                    .addComponent(tfBehNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnChoose)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlHeader.add(pnlEmpfaenger, java.awt.BorderLayout.NORTH);

        add(pnlHeader, java.awt.BorderLayout.NORTH);

        pnlMessageList.setLayout(new java.awt.BorderLayout());

        lblHeader.setFont(new java.awt.Font("Tahoma", 0, 14));
        lblHeader.setText("Nachrichten im OSCI-Postfach:");
        pnlMessageList.add(lblHeader, java.awt.BorderLayout.PAGE_START);

        tblOSCIMessages.setAutoCreateRowSorter(true);
        tblOSCIMessages.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {

            },
            new String [] {

            }
        ));
        tblOSCIMessages.setDefaultRenderer(String.class, new ZebraCellRendererDecorator(new DefaultTableCellRenderer()));
        tblOSCIMessages.setDefaultRenderer(Date.class, new ZebraCellRendererDecorator(new DateTimeCellRenderer()));
        tblOSCIMessages.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        tblOSCIMessages.getSelectionModel().addListSelectionListener(new ListSelectionListener() {
            public void valueChanged(ListSelectionEvent e) {
                if(tblOSCIMessages.getSelectedRow() !=-1){
                    btnGetMessage.setEnabled(true);
                } else {
                    btnGetMessage.setEnabled(false);
                }
            }
        });
        jScrollPane1.setViewportView(tblOSCIMessages);

        pnlMessageList.add(jScrollPane1, java.awt.BorderLayout.CENTER);

        btnGetMessage.setText(bundle.getString("RetrieveMessage")); // NOI18N
        btnGetMessage.setToolTipText(bundle.getString("ttNachrichtAbholen")); // NOI18N
        btnGetMessage.setEnabled(false);
        btnGetMessage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnGetMessageActionPerformed(evt);
            }
        });
        pnlMessageList.add(btnGetMessage, java.awt.BorderLayout.PAGE_END);

        add(pnlMessageList, java.awt.BorderLayout.CENTER);

        lblStatus.setText("Status:");
        add(lblStatus, java.awt.BorderLayout.PAGE_END);
    }// </editor-fold>//GEN-END:initComponents

    private void btnLoadMessagesActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLoadMessagesActionPerformed
        // Lädt eine Liste der OSCI Nachrichten im Postfach
        this.lblStatus.setText("Status: Empfange Liste...");
        this.btnLoadMessages.setEnabled(false);
        this.tblOSCIMessages.setEnabled(false);
        SwingUtilities.invokeLater(new Runnable() {

            @Override
            public void run() {
                List<MessageHeaderContainer> containers = proxy.getMessageList(address);
                MessageHeaderContainerTableModel tableModel = new MessageHeaderContainerTableModel(containers);
                tblOSCIMessages.setModel(tableModel);
                tblOSCIMessages.setEnabled(true);
                lblStatus.setText("Status: Fertig!");
                btnLoadMessages.setEnabled(true);
            }
        });


    }//GEN-LAST:event_btnLoadMessagesActionPerformed

    private void btnGetMessageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnGetMessageActionPerformed
        // Holt die ausgewählte Nachricht ab.
        int rowIndex = tblOSCIMessages.getSelectedRow();
        if (rowIndex != -1) {
            this.btnGetMessage.setEnabled(false);
            this.lblStatus.setText("Status: Empfange Nachricht");
            rowIndex = tblOSCIMessages.getRowSorter().convertRowIndexToModel(rowIndex);
            MessageHeaderContainerTableModel tm = (MessageHeaderContainerTableModel) tblOSCIMessages.getModel();
            final MessageHeaderContainer container = tm.getContainerAt(rowIndex);
            SwingUtilities.invokeLater(new Runnable() {

                @Override
                public void run() {
                    byte[] messageData = proxy.receiveMessageById(address, container.getId());
                    if (messageData != null) {
                        lblStatus.setText("Status: Fertig!");
                    } else {
                        lblStatus.setText("Fehler: Nachricht konnte nicht abgeholt werden, oder enthält keinen Inhalt!");
                    }
                    btnGetMessage.setEnabled(true);
                }
            });

        }
    }//GEN-LAST:event_btnGetMessageActionPerformed

    private void btnChooseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChooseActionPerformed
        // AddressChooserPanel in Dialog anzeigen
        AddressChooserPanel chooserPanel = new AddressChooserPanel(TYPE.ADDRESSES);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(chooserPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Postfach auswählen");
        dialog.setModal(true);
        dialog.setVisible(true);
        Address a = chooserPanel.getAddress();
        if (a != null) {
            this.address = a;
            initView();
        }
}//GEN-LAST:event_btnChooseActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChoose;
    private javax.swing.JButton btnGetMessage;
    private javax.swing.JButton btnLoadMessages;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblBehNummer;
    private javax.swing.JLabel lblHeader;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblStatus;
    private javax.swing.JPanel pnlEmpfaenger;
    private javax.swing.JPanel pnlHeader;
    private javax.swing.JPanel pnlMessageList;
    private javax.swing.JTable tblOSCIMessages;
    private javax.swing.JTextField tfBehNummer;
    private javax.swing.JTextField tfName;
    // End of variables declaration//GEN-END:variables
    private final OSCIProxy proxy;
    private Address address;

    private void initView() {
        if (address != null) {
            tfBehNummer.setText(address.getRegisterNumber());
            tfName.setText(address.getName1());
        }
        tblOSCIMessages.setModel(new MessageHeaderContainerTableModel(null));
    }
}
