/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * OSCIMessageListPanel.java
 *
 * Created on 09.10.2009, 16:07:03
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.BasicOSCIMessage;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author Marc Beck
 */
public class OSCIMessageListPanel extends javax.swing.JPanel {

    /** Creates new form OSCIMessageListPanel */
    public OSCIMessageListPanel(List<BasicOSCIMessage> oSCIMessages) {
        initComponents();

        if (oSCIMessages != null) {
            List<String> list = new ArrayList<String>();
            for (BasicOSCIMessage oSCIMessage : oSCIMessages) {
                list.add(oSCIMessage.getType());
            }
            this.lstOSCIMessages.setListData(oSCIMessages.toArray());
        }
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblTitle = new javax.swing.JLabel();
        btnView = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        lstOSCIMessages = new javax.swing.JList();

        setLayout(new java.awt.BorderLayout());

        lblTitle.setFont(new java.awt.Font("Tahoma", 1, 14));
        lblTitle.setText("OSCI Nachrichten");
        add(lblTitle, java.awt.BorderLayout.PAGE_START);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnView.setText(bundle.getString("View")); // NOI18N
        btnView.setToolTipText(bundle.getString("ttViewMessage")); // NOI18N
        btnView.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnViewActionPerformed(evt);
            }
        });
        add(btnView, java.awt.BorderLayout.PAGE_END);

        lstOSCIMessages.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lstOSCIMessages.setCellRenderer(new de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.OSCIMessageCellRenderer());
        jScrollPane1.setViewportView(lstOSCIMessages);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnViewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnViewActionPerformed
        //Nachricht anzeigen
        BasicOSCIMessage message = (BasicOSCIMessage) this.lstOSCIMessages.getSelectedValue();
        if (message != null) {
            try {
                FileUtil.viewFile(message.getMessage().getBytes("UTF-8"), ".txt");
            } catch (UnsupportedEncodingException ex) {
                Logger.getLogger(OSCIMessageListPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }//GEN-LAST:event_btnViewActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnView;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblTitle;
    private javax.swing.JList lstOSCIMessages;
    // End of variables declaration//GEN-END:variables
}
