/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ReceiveMessagePanel.java
 *
 * Created on 14.07.2009, 13:50:26
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.OSCIProxy;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel.TYPE;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 *
 * @author Marc Beck
 */
public class ReceiveMessagePanel extends javax.swing.JPanel {

    /** Creates new form ReceiveMessagePanel */
    public ReceiveMessagePanel() {
        this.receiver = company.getDefaultAddress();
        initComponents();
        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlEmpfaenger = new javax.swing.JPanel();
        lblBehNummer = new javax.swing.JLabel();
        tfBehNummer = new javax.swing.JTextField();
        lblName = new javax.swing.JLabel();
        tfName = new javax.swing.JTextField();
        btnChoose = new javax.swing.JButton();
        pnlButtons = new javax.swing.JPanel();
        btnAbrufen = new javax.swing.JButton();
        prbProgress = new javax.swing.JProgressBar();

        setLayout(new java.awt.BorderLayout());

        pnlEmpfaenger.setBorder(javax.swing.BorderFactory.createTitledBorder("Empfänger"));

        lblBehNummer.setText("Behördliche Nummer:");

        tfBehNummer.setColumns(20);
        tfBehNummer.setEditable(false);

        lblName.setText("Name:");

        tfName.setColumns(20);
        tfName.setEditable(false);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnChoose.setText(bundle.getString("Choose")); // NOI18N
        btnChoose.setToolTipText(bundle.getString("ttChooseEmpfaenger")); // NOI18N
        btnChoose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChooseActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlEmpfaengerLayout = new javax.swing.GroupLayout(pnlEmpfaenger);
        pnlEmpfaenger.setLayout(pnlEmpfaengerLayout);
        pnlEmpfaengerLayout.setHorizontalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnChoose, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblBehNummer)
                            .addComponent(lblName))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfName, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE)
                            .addComponent(tfBehNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 277, Short.MAX_VALUE))))
                .addContainerGap())
        );
        pnlEmpfaengerLayout.setVerticalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBehNummer)
                    .addComponent(tfBehNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnChoose)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(pnlEmpfaenger, java.awt.BorderLayout.NORTH);

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));

        btnAbrufen.setText(bundle.getString("FetchMessages")); // NOI18N
        btnAbrufen.setToolTipText(bundle.getString("ttNachrichtenAbrufen")); // NOI18N
        btnAbrufen.setAlignmentY(0.0F);
        btnAbrufen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnAbrufenActionPerformed(evt);
            }
        });
        pnlButtons.add(btnAbrufen);

        add(pnlButtons, java.awt.BorderLayout.CENTER);
        add(prbProgress, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnAbrufenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnAbrufenActionPerformed
        // Nachrichten abrufen
        btnAbrufen.setEnabled(false);
        //Progress Bar setzen
        prbProgress.setIndeterminate(true);
        final JPanel panel = this;

        //Nachrichten in neuem Thread abrufen
        new Thread() {

            @Override
            public void run() {
                OSCIProxy proxy = new OSCIProxy();
                String response = proxy.receive(receiver);
                JOptionPane.showMessageDialog(panel, response, MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);
                //Progress Bar abschalten
                prbProgress.setIndeterminate(false);
                //Button wieder erlauben
                btnAbrufen.setEnabled(true);
            }
        }.start();
    }//GEN-LAST:event_btnAbrufenActionPerformed

    private void btnChooseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChooseActionPerformed
        // UnternehmensAdresseChooserPanel in Dialog anzeigen
        AddressChooserPanel chooserPanel = new AddressChooserPanel(TYPE.ADDRESSES);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(chooserPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Adresse auswählen");
        dialog.setModal(true);
        dialog.setVisible(true);
        Address address = chooserPanel.getAddress();
        if (address != null) {
            this.receiver = address;
            initView();
        }
    }//GEN-LAST:event_btnChooseActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnAbrufen;
    private javax.swing.JButton btnChoose;
    private javax.swing.JLabel lblBehNummer;
    private javax.swing.JLabel lblName;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlEmpfaenger;
    private javax.swing.JProgressBar prbProgress;
    private javax.swing.JTextField tfBehNummer;
    private javax.swing.JTextField tfName;
    // End of variables declaration//GEN-END:variables
    private Address receiver;
    private Company company = CompanyFacade.getCompany();

    private void initView() {
        if (this.receiver != null) {
            tfBehNummer.setText(receiver.getRegisterNumber());
            tfName.setText(receiver.getName1());
        }

    }
}
