/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * NachrichtTestPanel.java
 *
 * Created on 10.07.2009, 13:25:36
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.zksservices.ZKSMessageUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.ProfilBuilder;
import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.OSCIProxy;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.DocumentType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.common.Profil;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel.TYPE;
import de.umweltcampus.uput.informatik.openeanvadapter.controller.CompanyFacade;
import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.masterdata.AddressChooserPanel;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

/**
 *
 * @author Marc Beck
 */
public class SendMessagePanel extends javax.swing.JPanel {

    /** Creates new form NachrichtTestPanel */
    public SendMessagePanel() {
        this.sender = company.getDefaultAddress();
        this.receiver = company.getContacts().get(0);
        initComponents();
        initView();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlNorth = new javax.swing.JPanel();
        pnlProfilierung = new javax.swing.JPanel();
        pnlAbsender = new javax.swing.JPanel();
        lblAbsenderBehNummer = new javax.swing.JLabel();
        tfAbsenderBehNummer = new javax.swing.JTextField();
        lblAbsenderName = new javax.swing.JLabel();
        tfAbsenderName = new javax.swing.JTextField();
        btnChooseAbsender = new javax.swing.JButton();
        pnlEmpfaenger = new javax.swing.JPanel();
        lblEmpfaengerBehNummer = new javax.swing.JLabel();
        lblEmpfaengerName = new javax.swing.JLabel();
        tfEmpfaengerBehNummer = new javax.swing.JTextField();
        tfEmpfaengerName = new javax.swing.JTextField();
        btnChooseEmpfaenger = new javax.swing.JButton();
        pnlNachricht = new javax.swing.JPanel();
        lblNachricht = new javax.swing.JLabel();
        tfNachricht = new javax.swing.JTextField();
        btnNachrichtSuchen = new javax.swing.JButton();
        lblNachrichtenTyp = new javax.swing.JLabel();
        tfMessageType = new javax.swing.JTextField();
        pnlSouth = new javax.swing.JPanel();
        pnlButtons = new javax.swing.JPanel();
        btnSenden = new javax.swing.JButton();
        pnlProgress = new javax.swing.JPanel();
        prbProgress = new javax.swing.JProgressBar();

        setLayout(new java.awt.BorderLayout());

        pnlNorth.setLayout(new java.awt.BorderLayout());

        pnlProfilierung.setBorder(javax.swing.BorderFactory.createTitledBorder("Profilierung"));
        pnlProfilierung.setLayout(new java.awt.GridLayout(1, 2));

        pnlAbsender.setBorder(javax.swing.BorderFactory.createTitledBorder("Absender"));

        lblAbsenderBehNummer.setText("Behördliche Nummer:");

        tfAbsenderBehNummer.setColumns(20);
        tfAbsenderBehNummer.setEditable(false);

        lblAbsenderName.setText("Name:");

        tfAbsenderName.setColumns(20);
        tfAbsenderName.setEditable(false);

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnChooseAbsender.setText(bundle.getString("Choose")); // NOI18N
        btnChooseAbsender.setToolTipText(bundle.getString("ttChooseAbsender")); // NOI18N
        btnChooseAbsender.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChooseAbsenderActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlAbsenderLayout = new javax.swing.GroupLayout(pnlAbsender);
        pnlAbsender.setLayout(pnlAbsenderLayout);
        pnlAbsenderLayout.setHorizontalGroup(
            pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAbsenderLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(btnChooseAbsender, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(pnlAbsenderLayout.createSequentialGroup()
                        .addGroup(pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblAbsenderBehNummer)
                            .addComponent(lblAbsenderName))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfAbsenderName, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE)
                            .addComponent(tfAbsenderBehNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE))))
                .addContainerGap())
        );
        pnlAbsenderLayout.setVerticalGroup(
            pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAbsenderLayout.createSequentialGroup()
                .addGroup(pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblAbsenderBehNummer)
                    .addComponent(tfAbsenderBehNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAbsenderLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblAbsenderName)
                    .addComponent(tfAbsenderName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnChooseAbsender)
                .addContainerGap(30, Short.MAX_VALUE))
        );

        pnlProfilierung.add(pnlAbsender);

        pnlEmpfaenger.setBorder(javax.swing.BorderFactory.createTitledBorder("Empfänger"));

        lblEmpfaengerBehNummer.setText("Behördliche Nummer:");

        lblEmpfaengerName.setText("Name:");

        tfEmpfaengerBehNummer.setColumns(20);
        tfEmpfaengerBehNummer.setEditable(false);

        tfEmpfaengerName.setColumns(20);
        tfEmpfaengerName.setEditable(false);

        btnChooseEmpfaenger.setText(bundle.getString("Choose")); // NOI18N
        btnChooseEmpfaenger.setToolTipText(bundle.getString("ttChooseEmpfaenger")); // NOI18N
        btnChooseEmpfaenger.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnChooseEmpfaengerActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlEmpfaengerLayout = new javax.swing.GroupLayout(pnlEmpfaenger);
        pnlEmpfaenger.setLayout(pnlEmpfaengerLayout);
        pnlEmpfaengerLayout.setHorizontalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblEmpfaengerBehNummer)
                            .addComponent(lblEmpfaengerName))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(tfEmpfaengerName, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE)
                            .addComponent(tfEmpfaengerBehNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 110, Short.MAX_VALUE)))
                    .addComponent(btnChooseEmpfaenger, javax.swing.GroupLayout.Alignment.TRAILING))
                .addContainerGap())
        );
        pnlEmpfaengerLayout.setVerticalGroup(
            pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlEmpfaengerLayout.createSequentialGroup()
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblEmpfaengerBehNummer)
                    .addComponent(tfEmpfaengerBehNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlEmpfaengerLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblEmpfaengerName)
                    .addComponent(tfEmpfaengerName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnChooseEmpfaenger)
                .addContainerGap(30, Short.MAX_VALUE))
        );

        pnlProfilierung.add(pnlEmpfaenger);

        pnlNorth.add(pnlProfilierung, java.awt.BorderLayout.NORTH);

        add(pnlNorth, java.awt.BorderLayout.NORTH);

        pnlNachricht.setBorder(javax.swing.BorderFactory.createTitledBorder("Nachricht"));

        lblNachricht.setText("BMU-Nachricht:");

        tfNachricht.setEditable(false);

        btnNachrichtSuchen.setText("...");
        btnNachrichtSuchen.setToolTipText(bundle.getString("ttChooseFile")); // NOI18N
        btnNachrichtSuchen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNachrichtSuchenActionPerformed(evt);
            }
        });

        lblNachrichtenTyp.setText("Nachrichtentyp:");

        tfMessageType.setColumns(20);
        tfMessageType.setEditable(false);
        tfMessageType.setHorizontalAlignment(javax.swing.JTextField.RIGHT);

        javax.swing.GroupLayout pnlNachrichtLayout = new javax.swing.GroupLayout(pnlNachricht);
        pnlNachricht.setLayout(pnlNachrichtLayout);
        pnlNachrichtLayout.setHorizontalGroup(
            pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlNachrichtLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblNachricht)
                    .addComponent(lblNachrichtenTyp, javax.swing.GroupLayout.PREFERRED_SIZE, 89, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(tfMessageType)
                    .addComponent(tfNachricht, javax.swing.GroupLayout.DEFAULT_SIZE, 274, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnNachrichtSuchen)
                .addContainerGap(60, Short.MAX_VALUE))
        );
        pnlNachrichtLayout.setVerticalGroup(
            pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlNachrichtLayout.createSequentialGroup()
                .addGroup(pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblNachricht)
                    .addComponent(tfNachricht, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btnNachrichtSuchen))
                .addGap(7, 7, 7)
                .addGroup(pnlNachrichtLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblNachrichtenTyp)
                    .addComponent(tfMessageType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(27, Short.MAX_VALUE))
        );

        add(pnlNachricht, java.awt.BorderLayout.CENTER);

        pnlSouth.setLayout(new java.awt.BorderLayout());

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));

        btnSenden.setText(bundle.getString("Send")); // NOI18N
        btnSenden.setToolTipText(bundle.getString("ttSenden")); // NOI18N
        btnSenden.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSendenActionPerformed(evt);
            }
        });
        pnlButtons.add(btnSenden);

        pnlSouth.add(pnlButtons, java.awt.BorderLayout.NORTH);

        pnlProgress.setLayout(new java.awt.BorderLayout());
        pnlProgress.add(prbProgress, java.awt.BorderLayout.SOUTH);

        pnlSouth.add(pnlProgress, java.awt.BorderLayout.SOUTH);

        add(pnlSouth, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void btnNachrichtSuchenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNachrichtSuchenActionPerformed
        // BMU Nachricht suchen
        JFileChooser chooser = new JFileChooser();
        //Nur BMU Nachrichten zulassen
        chooser.addChoosableFileFilter(new FileFilter() {

            @Override
            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().toLowerCase().endsWith(".xml");
            }

            @Override
            public String getDescription() {
                return "BMU-Nachricht (*.xml)";
            }
        });
        chooser.setMultiSelectionEnabled(false);
        if (chooser.showOpenDialog(this)
                == JFileChooser.APPROVE_OPTION) {
            String filename = chooser.getSelectedFile().getAbsolutePath();
            this.tfNachricht.setText(filename);
        }
        //Datei einlesen
        readFile();
        if (fileContent != null) {
            //Typ überprüfen
            String messageType = ZKSMessageUtil.detectMessageType(new String(fileContent));
            if (messageType.equals("unbekannt")) {
                JOptionPane.showMessageDialog(this, MessageBundle.getString("msgNoBMUMessage"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
                fileContent = null;
                tfMessageType.setText("");
                tfNachricht.setText("");
            } else {
                tfMessageType.setText(messageType);
            }
        }
    }//GEN-LAST:event_btnNachrichtSuchenActionPerformed

    private void btnSendenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnSendenActionPerformed
        //Nix machen, wenn keine Datei angegeben wurde
        if (fileContent != null) {
            //Button sperren
            btnSenden.setEnabled(false);
            //Progress Bar setzen
            prbProgress.setIndeterminate(true);
            final JPanel panel = this;

            new Thread() {

                @Override
                public void run() {
                    // Profil zusammenbauen
                    DocumentType dokTyp = DocumentType.valueOf(tfMessageType.getText());
                    String pseudoUUID = UUID.randomUUID().toString().substring(0, 15);
                    ProfilBuilder builder = new ProfilBuilder();
                    Profil profil = builder.buildProfil(receiver, sender, dokTyp, pseudoUUID);
                    if (profil == null) {
                        JOptionPane.showMessageDialog(panel, MessageBundle.getString("msgProfileError"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
                        prbProgress.setIndeterminate(false);
                        return;
                    }
                    //Senden
                    OSCIProxy proxy = new OSCIProxy();
                    String response = proxy.send(sender, receiver.getPublicCertificate().getCertificate(), profil, fileContent);
                    JOptionPane.showMessageDialog(panel, response, MessageBundle.getString("msgInfo"), JOptionPane.INFORMATION_MESSAGE);

                    //Progress Bar abschalten
                    prbProgress.setIndeterminate(false);
                    //Button wieder erlauben
                    btnSenden.setEnabled(true);
                }
            }.start();
        } else {
            JOptionPane.showMessageDialog(this, MessageBundle.getString("msgNoBMUMessageToSend"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
        }


    }//GEN-LAST:event_btnSendenActionPerformed

    private void btnChooseEmpfaengerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChooseEmpfaengerActionPerformed
        // AddressChooserPanel in Dialog anzeigen
        AddressChooserPanel chooserPanel = new AddressChooserPanel(TYPE.CONTACTS);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(chooserPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Adresse auswählen");
        dialog.setModal(true);
        dialog.setVisible(true);
        Address address = chooserPanel.getAddress();
        if (address != null) {
            this.receiver = address;
            initView();
        }
    }//GEN-LAST:event_btnChooseEmpfaengerActionPerformed

    private void btnChooseAbsenderActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnChooseAbsenderActionPerformed
        // UnternehmensAdresseChooserPanel in Dialog anzeigen
        AddressChooserPanel chooserPanel = new AddressChooserPanel(TYPE.ADDRESSES);
        JDialog dialog = new JDialog(JOptionPane.getFrameForComponent(this));
        dialog.setContentPane(chooserPanel);
        dialog.pack();
        dialog.setLocationRelativeTo(this);
        dialog.setTitle("Adresse auswählen");
        dialog.setModal(true);
        dialog.setVisible(true);
        Address address = chooserPanel.getAddress();
        if (address != null) {
            this.sender = address;
            initView();
        }

    }//GEN-LAST:event_btnChooseAbsenderActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnChooseAbsender;
    private javax.swing.JButton btnChooseEmpfaenger;
    private javax.swing.JButton btnNachrichtSuchen;
    private javax.swing.JButton btnSenden;
    private javax.swing.JLabel lblAbsenderBehNummer;
    private javax.swing.JLabel lblAbsenderName;
    private javax.swing.JLabel lblEmpfaengerBehNummer;
    private javax.swing.JLabel lblEmpfaengerName;
    private javax.swing.JLabel lblNachricht;
    private javax.swing.JLabel lblNachrichtenTyp;
    private javax.swing.JPanel pnlAbsender;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlEmpfaenger;
    private javax.swing.JPanel pnlNachricht;
    private javax.swing.JPanel pnlNorth;
    private javax.swing.JPanel pnlProfilierung;
    private javax.swing.JPanel pnlProgress;
    private javax.swing.JPanel pnlSouth;
    private javax.swing.JProgressBar prbProgress;
    private javax.swing.JTextField tfAbsenderBehNummer;
    private javax.swing.JTextField tfAbsenderName;
    private javax.swing.JTextField tfEmpfaengerBehNummer;
    private javax.swing.JTextField tfEmpfaengerName;
    private javax.swing.JTextField tfMessageType;
    private javax.swing.JTextField tfNachricht;
    // End of variables declaration//GEN-END:variables
    private Company company = CompanyFacade.getCompany();
    private byte[] fileContent;
    private Address receiver;
    private Address sender;

    private void initView() {
        if (this.receiver != null) {
            tfEmpfaengerBehNummer.setText(receiver.getRegisterNumber());
            tfEmpfaengerName.setText(receiver.getName1());
        }
        if (this.sender != null) {
            tfAbsenderBehNummer.setText(sender.getRegisterNumber());
            tfAbsenderName.setText(sender.getName1());
        }
    }

    private void readFile() {
        //Datei einlesen
        String filename = tfNachricht.getText();
        if (!"".equals(filename)) {
            try {
                //Datei einlesen
                File f = new File(filename);
                FileInputStream fis = new FileInputStream(f);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int i = 0;
                while ((i = fis.read()) != -1) {
                    baos.write(i);
                }
                fis.close();
                baos.close();
                this.fileContent = baos.toByteArray();

            } catch (IOException ex) {
                JOptionPane.showMessageDialog(this, MessageBundle.getString("msgErrorReadingFile"), MessageBundle.getString("msgError"), JOptionPane.ERROR_MESSAGE);
                Logger.getLogger(SendMessagePanel.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
    }
}
