/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * WebServiceMonitorPanel.java
 *
 * Created on 09.12.2009, 10:13:28
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.webservice;

import de.umweltcampus.uput.informatik.openeanvadapter.communication.adapterservices.WSDeployer;
import de.umweltcampus.uput.informatik.openeanvadapter.util.MessageRequirementsValidator;
import javax.swing.JOptionPane;

/**
 * Überwachungsinstrument für den Adapter-eigenen Webservice
 * @author Marc Beck
 */
public class WebServiceMonitorPanel extends javax.swing.JPanel {

    /** Creates new form WebServiceMonitorPanel */
    public WebServiceMonitorPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlButtons = new javax.swing.JPanel();
        btnStartAdapterWS = new javax.swing.JButton();
        btnStopAdapterWS = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        txaWebServiceLog = new javax.swing.JTextArea();

        setBorder(javax.swing.BorderFactory.createTitledBorder("Webservice Monitor"));
        setLayout(new java.awt.BorderLayout());

        pnlButtons.setLayout(new javax.swing.BoxLayout(pnlButtons, javax.swing.BoxLayout.LINE_AXIS));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnStartAdapterWS.setText(bundle.getString("StartWebservice")); // NOI18N
        btnStartAdapterWS.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStartAdapterWSActionPerformed(evt);
            }
        });
        pnlButtons.add(btnStartAdapterWS);

        btnStopAdapterWS.setText(bundle.getString("StopWebservice")); // NOI18N
        btnStopAdapterWS.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStopAdapterWSActionPerformed(evt);
            }
        });
        pnlButtons.add(btnStopAdapterWS);

        add(pnlButtons, java.awt.BorderLayout.NORTH);

        txaWebServiceLog.setColumns(20);
        txaWebServiceLog.setEditable(false);
        txaWebServiceLog.setRows(5);
        jScrollPane1.setViewportView(txaWebServiceLog);

        add(jScrollPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnStartAdapterWSActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStartAdapterWSActionPerformed
        // Den Webservice starten
        if (!MessageRequirementsValidator.validateCompany()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageCompany(), "Fehler", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (!MessageRequirementsValidator.validateZKS()) {
            JOptionPane.showMessageDialog(this, MessageRequirementsValidator.getMessageZKS(), "Fehler", JOptionPane.ERROR_MESSAGE);
            return;
        }
        if (!deployer.alive()) {
            deployer = new WSDeployer();
        }
        String result = deployer.startServer();
        result = this.txaWebServiceLog.getText() + "\n" + result;
        this.txaWebServiceLog.setText(result);
    }//GEN-LAST:event_btnStartAdapterWSActionPerformed

    private void btnStopAdapterWSActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStopAdapterWSActionPerformed
        // Den Webservice beenden
        String result = deployer.shutdownServer();
        result = this.txaWebServiceLog.getText() + "\n" + result;
        this.txaWebServiceLog.setText(result);

    }//GEN-LAST:event_btnStopAdapterWSActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnStartAdapterWS;
    private javax.swing.JButton btnStopAdapterWS;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JTextArea txaWebServiceLog;
    // End of variables declaration//GEN-END:variables
    private WSDeployer deployer = new WSDeployer();
}
