/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * CompanyPanel.java
 *
 * Created on 15.01.2010, 15:37:49
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.util.GenericUtils;
import de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument;
import de.umweltcampus.uput.informatik.openeanvadapter.view.renderers.RoleTypeListCellRenderer;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldRegexValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;

/**
 *
 * @author Timo Johann
 */
public class CompanyPanel extends javax.swing.JPanel implements WizardPanel {

    /** Creates new form CompanyPanel */
    public CompanyPanel() {
        initComponents();
        validatorChain = new ValidatorChain();
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfBehoerdlicheNummer, "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldRegexValidator(tfBehoerdlicheNummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Behördliche Nummer"));
        validatorChain.registerValidator(new JTextFieldNotEmptyValidator(tfName, "Name"));


    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlBanner = new javax.swing.JPanel();
        lblProgressImage = new javax.swing.JLabel();
        pnlContent = new javax.swing.JPanel();
        pnlAllgemein = new javax.swing.JPanel();
        lblBehoerdlicheNummer = new javax.swing.JLabel();
        lblName = new javax.swing.JLabel();
        lblPostleitzahl = new javax.swing.JLabel();
        lblOrt = new javax.swing.JLabel();
        lblRolle = new javax.swing.JLabel();
        tfBehoerdlicheNummer = new javax.swing.JTextField();
        tfName = new javax.swing.JTextField();
        tfOrt = new javax.swing.JTextField();
        tfPostleitzahl = new javax.swing.JTextField();
        cbRolle = new javax.swing.JComboBox();
        pnlZertifikat = new javax.swing.JPanel();
        btnShowZertifikat = new javax.swing.JButton();
        btnImportZertifikat = new javax.swing.JButton();
        pnlSignaturZertifikat2 = new javax.swing.JPanel();
        btnImportSignaturzertifikat2 = new javax.swing.JButton();
        pfPassword2 = new javax.swing.JPasswordField();
        lblPassword2 = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        pnlBanner.setLayout(new java.awt.BorderLayout());

        lblProgressImage.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/umweltcampus/uput/informatik/openeanvadapter/resources/adapter_wizard2.PNG"))); // NOI18N
        pnlBanner.add(lblProgressImage, java.awt.BorderLayout.CENTER);

        add(pnlBanner, java.awt.BorderLayout.WEST);

        pnlContent.setLayout(new java.awt.BorderLayout());

        pnlAllgemein.setBorder(javax.swing.BorderFactory.createTitledBorder("Allgemeine Daten"));

        lblBehoerdlicheNummer.setText("Behördliche Nummer:");

        lblName.setText("Name:");

        lblPostleitzahl.setText("Postleitzahl:");

        lblOrt.setText("Ort:");

        lblRolle.setText("Rolle:");

        tfBehoerdlicheNummer.setDocument(new RestrictingDocument(9));
        tfBehoerdlicheNummer.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfBehoerdlicheNummerFocusLost(evt);
            }
        });

        tfName.setDocument(new RestrictingDocument(35));

        tfOrt.setDocument(new RestrictingDocument(35));

        tfPostleitzahl.setColumns(20);
        tfPostleitzahl.setDocument(new RestrictingDocument(9));
        tfPostleitzahl.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                tfPostleitzahlFocusLost(evt);
            }
        });

        cbRolle.setModel(new DefaultComboBoxModel(RoleType.values()));
        cbRolle.setRenderer(new RoleTypeListCellRenderer(false));

        javax.swing.GroupLayout pnlAllgemeinLayout = new javax.swing.GroupLayout(pnlAllgemein);
        pnlAllgemein.setLayout(pnlAllgemeinLayout);
        pnlAllgemeinLayout.setHorizontalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                        .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblBehoerdlicheNummer)
                            .addComponent(lblName)
                            .addComponent(lblOrt)
                            .addComponent(lblRolle))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(cbRolle, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(tfOrt)
                            .addComponent(tfName)
                            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                                .addGap(136, 136, 136)
                                .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, 91, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                        .addComponent(lblPostleitzahl)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(71, Short.MAX_VALUE))
        );
        pnlAllgemeinLayout.setVerticalGroup(
            pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAllgemeinLayout.createSequentialGroup()
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblBehoerdlicheNummer)
                    .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblName)
                    .addComponent(tfName, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblPostleitzahl)
                    .addComponent(tfPostleitzahl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblOrt)
                    .addComponent(tfOrt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlAllgemeinLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblRolle)
                    .addComponent(cbRolle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pnlContent.add(pnlAllgemein, java.awt.BorderLayout.NORTH);

        pnlZertifikat.setBorder(javax.swing.BorderFactory.createTitledBorder("Öffentliches Adressierungszertifikat"));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnShowZertifikat.setText(bundle.getString("View")); // NOI18N
        btnShowZertifikat.setToolTipText(bundle.getString("ttZertifikatAnzeigen")); // NOI18N
        btnShowZertifikat.setEnabled(false);
        btnShowZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnShowZertifikatActionPerformed(evt);
            }
        });

        btnImportZertifikat.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikat.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout pnlZertifikatLayout = new javax.swing.GroupLayout(pnlZertifikat);
        pnlZertifikat.setLayout(pnlZertifikatLayout);
        pnlZertifikatLayout.setHorizontalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(btnShowZertifikat, javax.swing.GroupLayout.PREFERRED_SIZE, 92, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnImportZertifikat)
                .addContainerGap(206, Short.MAX_VALUE))
        );
        pnlZertifikatLayout.setVerticalGroup(
            pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlZertifikatLayout.createSequentialGroup()
                .addGroup(pnlZertifikatLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(btnShowZertifikat)
                    .addComponent(btnImportZertifikat))
                .addContainerGap(127, Short.MAX_VALUE))
        );

        pnlContent.add(pnlZertifikat, java.awt.BorderLayout.CENTER);

        pnlSignaturZertifikat2.setBorder(javax.swing.BorderFactory.createTitledBorder("Privates Signatur- und Verschlüsselungszertifikat"));

        btnImportSignaturzertifikat2.setText(bundle.getString("Import")); // NOI18N
        btnImportSignaturzertifikat2.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportSignaturzertifikat2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportSignaturzertifikat2ActionPerformed(evt);
            }
        });

        lblPassword2.setText("Passwort:");

        javax.swing.GroupLayout pnlSignaturZertifikat2Layout = new javax.swing.GroupLayout(pnlSignaturZertifikat2);
        pnlSignaturZertifikat2.setLayout(pnlSignaturZertifikat2Layout);
        pnlSignaturZertifikat2Layout.setHorizontalGroup(
            pnlSignaturZertifikat2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSignaturZertifikat2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblPassword2)
                .addGap(57, 57, 57)
                .addComponent(pfPassword2, javax.swing.GroupLayout.PREFERRED_SIZE, 127, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(btnImportSignaturzertifikat2)
                .addContainerGap(62, Short.MAX_VALUE))
        );
        pnlSignaturZertifikat2Layout.setVerticalGroup(
            pnlSignaturZertifikat2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSignaturZertifikat2Layout.createSequentialGroup()
                .addGroup(pnlSignaturZertifikat2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(pfPassword2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblPassword2)
                    .addComponent(btnImportSignaturzertifikat2))
                .addContainerGap(75, Short.MAX_VALUE))
        );

        pnlContent.add(pnlSignaturZertifikat2, java.awt.BorderLayout.SOUTH);

        add(pnlContent, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnShowZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnShowZertifikatActionPerformed
        //Zertifikat anzeigen
        if (publicCert != null) {
            FileUtil.viewFile(publicCert, ".cer");
        }
}//GEN-LAST:event_btnShowZertifikatActionPerformed

    private void btnImportZertifikatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatActionPerformed
        //Zertifikat importieren
        publicCert = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (publicCert != null) {
            this.btnShowZertifikat.setEnabled(true);
        }
}//GEN-LAST:event_btnImportZertifikatActionPerformed

    private void btnImportSignaturzertifikat2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportSignaturzertifikat2ActionPerformed
        //Zertifikat importieren
        privateCert = FileUtil.readFile(this, ".p12", "Zertifikat");
        if (privateCert != null) {
            JOptionPane.showMessageDialog(this, "Das Zertifikat wurde importiert!", "Info", JOptionPane.INFORMATION_MESSAGE);
        }
}//GEN-LAST:event_btnImportSignaturzertifikat2ActionPerformed

    private void tfBehoerdlicheNummerFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfBehoerdlicheNummerFocusLost
    }//GEN-LAST:event_tfBehoerdlicheNummerFocusLost

    private void tfPostleitzahlFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_tfPostleitzahlFocusLost
    }//GEN-LAST:event_tfPostleitzahlFocusLost
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnImportSignaturzertifikat2;
    private javax.swing.JButton btnImportZertifikat;
    private javax.swing.JButton btnShowZertifikat;
    private javax.swing.JComboBox cbRolle;
    private javax.swing.JLabel lblBehoerdlicheNummer;
    private javax.swing.JLabel lblName;
    private javax.swing.JLabel lblOrt;
    private javax.swing.JLabel lblPassword2;
    private javax.swing.JLabel lblPostleitzahl;
    private javax.swing.JLabel lblProgressImage;
    private javax.swing.JLabel lblRolle;
    private javax.swing.JPasswordField pfPassword2;
    private javax.swing.JPanel pnlAllgemein;
    private javax.swing.JPanel pnlBanner;
    private javax.swing.JPanel pnlContent;
    private javax.swing.JPanel pnlSignaturZertifikat2;
    private javax.swing.JPanel pnlZertifikat;
    private javax.swing.JTextField tfBehoerdlicheNummer;
    private javax.swing.JTextField tfName;
    private javax.swing.JTextField tfOrt;
    private javax.swing.JTextField tfPostleitzahl;
    // End of variables declaration//GEN-END:variables
    private ValidatorChain validatorChain;
    private byte[] publicCert;
    private byte[] privateCert;

    @Override
    public void handleData(WizardDataContainer container) {
        container.setName(tfName.getText());
        container.setBehoerdlichNummer(tfBehoerdlicheNummer.getText());
        container.setRolle((RoleType) cbRolle.getSelectedItem());
        container.setPlz(Integer.valueOf(tfPostleitzahl.getText()));
        container.setOrt(tfOrt.getText());
        container.setPrivateCert(privateCert);
        container.setPublicCert(publicCert);
        container.setCertPassword(pfPassword2.getPassword());

    }

    @Override
    public boolean isWizardPanelValid() {
        if (privateCert != null && pfPassword2.getPassword() != null) {
            String password = new String(pfPassword2.getPassword());
            boolean valid = GenericUtils.checkPassword(privateCert, password);
            if (!valid) {
                JOptionPane.showMessageDialog(this, "Fehler: Das eingebebene Passwort für das private Zertifikat ist ungültig.", "Fehler", JOptionPane.ERROR_MESSAGE);
                return false;
            }
        }

        boolean isValidated = validatorChain.runValidation();

        if ((privateCert == null || publicCert == null) && isValidated) {
            if (JOptionPane.showConfirmDialog(this, "Es wurden nicht alle Zertifikate für Ihr Unternehmen ausgewählt, diese werden für die Kommunikation mit der ZKS benötigt. Trotzdem fortsetzen?", "Bestätigen", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                validatorChain.runValidation();
                return true;
            } else {
                return false;
            }
        }
        return validatorChain.runValidation();
    }
}
